/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpOutboundGateway
extends AbstractReplyProducingMessageHandler
implements TcpSender,
TcpListener {
    protected AbstractConnectionFactory connectionFactory;
    private Map<String, AsyncReply> pendingReplies = new ConcurrentHashMap<String, AsyncReply>();
    private Semaphore semaphore = new Semaphore(1, true);
    private long replyTimeout = 10000L;
    private long requestTimeout = 10000L;

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Assert.notNull((Object)this.connectionFactory, (String)(this.getClass().getName() + " requires a client connection factory"));
        boolean haveSemaphore = false;
        try {
            boolean singleUseConnection = this.connectionFactory.isSingleUse();
            if (!singleUseConnection) {
                this.logger.debug((Object)"trying semaphore");
                if (!this.semaphore.tryAcquire(this.requestTimeout, TimeUnit.MILLISECONDS)) {
                    throw new MessageTimeoutException(requestMessage, "Timed out waiting for connection");
                }
                haveSemaphore = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"got semaphore");
                }
            }
            TcpConnection connection = this.connectionFactory.getConnection();
            AsyncReply reply = new AsyncReply();
            this.pendingReplies.put(connection.getConnectionId(), reply);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added " + connection.getConnectionId()));
            }
            connection.send(requestMessage);
            Message<?> replyMessage = reply.getReply();
            if (replyMessage == null) {
                throw new MessageTimeoutException(requestMessage, "Timed out waiting for response");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Respose " + replyMessage));
            }
            Message<?> message = replyMessage;
            return message;
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            this.logger.error((Object)"Tcp Gateway exception", (Throwable)e);
            throw new MessagingException("Failed to send or receive", (Throwable)e);
        }
        finally {
            if (haveSemaphore) {
                this.semaphore.release();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"released semaphore");
                }
            }
        }
    }

    @Override
    public boolean onMessage(Message<?> message) {
        String connectionId = (String)message.getHeaders().get((Object)"ip_connection_id");
        if (connectionId == null) {
            this.logger.error((Object)"Cannot correlate response - no connection id");
            return false;
        }
        AsyncReply reply = this.pendingReplies.get(connectionId);
        if (reply == null) {
            this.logger.error((Object)"Cannot correlate response - no pending reply");
            return false;
        }
        reply.setReply(message);
        return false;
    }

    public boolean isListening() {
        return false;
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        Assert.isTrue((boolean)(connectionFactory instanceof AbstractClientConnectionFactory), (String)(this.getClass().getName() + " requires a client connection factory"));
        this.connectionFactory = connectionFactory;
        connectionFactory.registerListener(this);
        connectionFactory.registerSender(this);
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public String getComponentType() {
        return "ip:tcp-outbound-gateway";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncReply {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile Message<?> reply;

        public Message<?> getReply() throws Exception {
            try {
                if (!this.latch.await(TcpOutboundGateway.this.replyTimeout, TimeUnit.MILLISECONDS)) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.reply;
        }

        public void setReply(Message<?> reply) {
            this.reply = reply;
            this.latch.countDown();
        }
    }
}

