/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTcpConnection
implements TcpConnection {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Deserializer deserializer;
    protected Serializer serializer;
    protected TcpMessageMapper mapper;
    protected TcpListener listener;
    private TcpListener actualListener;
    protected TcpSender sender;
    protected boolean singleUse;
    protected final boolean server;
    protected String connectionId;
    private AtomicLong sequence = new AtomicLong();
    private int soLinger = -1;
    private String hostName = "unknown";
    private String hostAddress = "unknown";
    private int port;
    private final boolean lookupHost;
    private int hashCode;

    public AbstractTcpConnection(Socket socket, boolean server, boolean lookupHost) {
        this.server = server;
        this.lookupHost = lookupHost;
        this.hashCode = socket.hashCode();
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress != null) {
            this.hostAddress = inetAddress.getHostAddress();
            this.hostName = this.lookupHost ? inetAddress.getHostName() : this.hostAddress;
        }
        this.connectionId = this.hostName + ":" + this.port + ":" + this.hashCode;
        try {
            this.soLinger = socket.getSoLinger();
        }
        catch (SocketException e) {
            // empty catch block
        }
    }

    public void afterSend(Message<?> message) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message sent " + message));
        }
        if (this.singleUse && (this.isServer() || this.actualListener == null) && this.soLinger != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing single-use connection" + this.getConnectionId()));
            }
            this.closeConnection();
        }
    }

    @Override
    public void close() {
        if (this.sender != null) {
            this.sender.removeDeadConnection(this);
        }
    }

    protected void closeConnection() {
        if (!(this.listener instanceof TcpConnectionInterceptor)) {
            this.close();
            return;
        }
        TcpConnectionInterceptor outerInterceptor = (TcpConnectionInterceptor)this.listener;
        while (outerInterceptor.getListener() instanceof TcpConnectionInterceptor) {
            outerInterceptor = (TcpConnectionInterceptor)outerInterceptor.getListener();
        }
        outerInterceptor.close();
    }

    public TcpMessageMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        Assert.notNull((Object)mapper, (String)(this.getClass().getName() + " Mapper may not be null"));
        this.mapper = mapper;
        if (this.serializer != null && !(this.serializer instanceof AbstractByteArraySerializer)) {
            mapper.setStringToBytes(false);
        }
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.deserializer;
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.serializer = serializer;
        if (!(serializer instanceof AbstractByteArraySerializer)) {
            this.mapper.setStringToBytes(false);
        }
    }

    @Override
    public void registerListener(TcpListener listener) {
        this.listener = listener;
        if (!(this.listener instanceof TcpConnectionInterceptor)) {
            this.actualListener = this.listener;
        } else {
            TcpConnectionInterceptor outerInterceptor = (TcpConnectionInterceptor)this.listener;
            while (outerInterceptor.getListener() instanceof TcpConnectionInterceptor) {
                outerInterceptor = (TcpConnectionInterceptor)outerInterceptor.getListener();
            }
            this.actualListener = outerInterceptor.getListener();
        }
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.sender = sender;
        if (sender != null) {
            sender.addNewConnection(this);
        }
    }

    @Override
    public TcpListener getListener() {
        return this.listener;
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    @Override
    public boolean isSingleUse() {
        return this.singleUse;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public long getConnectionSeq() {
        return this.sequence.incrementAndGet();
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }
}

