/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.UnsupportedEncodingException;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpMessageMapper
implements InboundMessageMapper<TcpConnection>,
OutboundMessageMapper<Object> {
    private volatile String charset = "UTF-8";
    private volatile boolean stringToBytes = true;

    public Message<Object> toMessage(TcpConnection connection) throws Exception {
        Message message = null;
        Object payload = connection.getPayload();
        if (payload != null) {
            message = MessageBuilder.withPayload((Object)payload).setHeader("ip_hostname", (Object)connection.getHostName()).setHeader("ip_address", (Object)connection.getHostAddress()).setHeader("ip_tcp_remote_port", (Object)connection.getPort()).setHeader("ip_connection_id", (Object)connection.getConnectionId()).setHeader("ip_connection_seq", (Object)connection.getConnectionSeq()).build();
        }
        return message;
    }

    public Object fromMessage(Message<?> message) throws Exception {
        if (this.stringToBytes) {
            return this.getPayloadAsBytes(message);
        }
        return message.getPayload();
    }

    private byte[] getPayloadAsBytes(Message<?> message) {
        byte[] bytes = null;
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else if (payload instanceof String) {
            try {
                bytes = ((String)payload).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageHandlingException(message, (Throwable)e);
            }
        } else {
            throw new MessageHandlingException(message, "When using a byte array serializer, the socket mapper expects either a byte array or String payload, but received: " + payload.getClass());
        }
        return bytes;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setStringToBytes(boolean stringToBytes) {
        this.stringToBytes = stringToBytes;
    }
}

