/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.net.Socket;
import javax.net.SocketFactory;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;

public class TcpNetClientConnectionFactory
extends AbstractClientConnectionFactory {
    public TcpNetClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    public TcpConnection getConnection() throws Exception {
        if (this.theConnection != null && this.theConnection.isOpen()) {
            return this.theConnection;
        }
        this.logger.debug((Object)("Opening new socket connection to " + this.host + ":" + this.port));
        Socket socket = SocketFactory.getDefault().createSocket(this.host, this.port);
        this.setSocketAttributes(socket);
        TcpConnection connection = new TcpNetConnection(socket, false, this.isLookupHost());
        connection = this.wrapConnection(connection);
        this.initializeConnection(connection, socket);
        this.getTaskExecutor().execute(connection);
        if (!this.singleUse) {
            this.theConnection = connection;
        }
        this.harvestClosedConnections();
        return connection;
    }

    public void close() {
    }

    public void run() {
    }

    public boolean isRunning() {
        return this.active;
    }
}

