/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;

public class TcpNetServerConnectionFactory
extends AbstractServerConnectionFactory {
    protected ServerSocket serverSocket;

    public TcpNetServerConnectionFactory(int port) {
        super(port);
    }

    public void run() {
        ServerSocket theServerSocket = null;
        if (this.listener == null) {
            this.logger.info((Object)"No listener bound to server connection factory; will not read; exiting...");
            return;
        }
        try {
            if (this.localAddress == null) {
                this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port, Math.abs(this.poolSize));
            } else {
                InetAddress whichNic = InetAddress.getByName(this.localAddress);
                this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port, Math.abs(this.poolSize), whichNic);
            }
            theServerSocket = this.serverSocket;
            this.listening = true;
            this.logger.info((Object)("Listening on port " + this.port));
            while (true) {
                Socket socket = this.serverSocket.accept();
                this.logger.debug((Object)("Accepted connection from " + socket.getInetAddress().getHostAddress()));
                this.setSocketAttributes(socket);
                TcpConnection connection = new TcpNetConnection(socket, true, this.isLookupHost());
                connection = this.wrapConnection(connection);
                this.initializeConnection(connection, socket);
                this.getTaskExecutor().execute(connection);
                this.harvestClosedConnections();
            }
        }
        catch (Exception e) {
            this.listening = false;
            if (e instanceof SocketException && theServerSocket != null) {
                this.logger.warn((Object)"Server Socket closed");
            } else if (this.active) {
                this.logger.error((Object)"Error on ServerSocket", (Throwable)e);
            }
            this.active = false;
            return;
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    public void close() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }
}

