/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.Message;
import org.springframework.integration.ip.tcp.connection.NoListenerException;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpConnectionInterceptor;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpMessageMapper;
import org.springframework.integration.ip.tcp.connection.TcpSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTcpConnectionInterceptor
implements TcpConnectionInterceptor {
    private TcpConnection theConnection;
    private TcpListener tcpListener;
    private TcpSender tcpSender;
    private Boolean realSender;

    @Override
    public void close() {
        this.theConnection.close();
    }

    @Override
    public boolean isOpen() {
        return this.theConnection.isOpen();
    }

    @Override
    public Object getPayload() throws Exception {
        return this.theConnection.getPayload();
    }

    @Override
    public String getHostName() {
        return this.theConnection.getHostName();
    }

    @Override
    public String getHostAddress() {
        return this.theConnection.getHostAddress();
    }

    @Override
    public int getPort() {
        return this.theConnection.getPort();
    }

    @Override
    public void registerListener(TcpListener listener) {
        this.tcpListener = listener;
        this.theConnection.registerListener(this);
    }

    @Override
    public void registerSender(TcpSender sender) {
        this.tcpSender = sender;
        this.theConnection.registerSender(this);
    }

    @Override
    public String getConnectionId() {
        return this.theConnection.getConnectionId();
    }

    @Override
    public boolean isSingleUse() {
        return this.theConnection.isSingleUse();
    }

    @Override
    public void run() {
        this.theConnection.run();
    }

    @Override
    public void setSingleUse(boolean singleUse) {
        this.theConnection.setSingleUse(singleUse);
    }

    @Override
    public void setMapper(TcpMessageMapper mapper) {
        this.theConnection.setMapper(mapper);
    }

    @Override
    public Deserializer<?> getDeserializer() {
        return this.theConnection.getDeserializer();
    }

    @Override
    public void setDeserializer(Deserializer<?> deserializer) {
        this.theConnection.setDeserializer(deserializer);
    }

    @Override
    public Serializer<?> getSerializer() {
        return this.theConnection.getSerializer();
    }

    @Override
    public void setSerializer(Serializer<?> serializer) {
        this.theConnection.setSerializer(serializer);
    }

    @Override
    public boolean isServer() {
        return this.theConnection.isServer();
    }

    @Override
    public boolean onMessage(Message<?> message) {
        if (this.tcpListener == null) {
            throw new NoListenerException("No listener registered for message reception");
        }
        return this.tcpListener.onMessage(message);
    }

    @Override
    public void send(Message<?> message) throws Exception {
        this.theConnection.send(message);
    }

    public TcpConnection getTheConnection() {
        return this.theConnection;
    }

    @Override
    public void setTheConnection(TcpConnection theConnection) {
        this.theConnection = theConnection;
    }

    @Override
    public TcpListener getListener() {
        return this.tcpListener;
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        if (this.tcpSender != null) {
            this.tcpSender.addNewConnection(this);
        }
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        if (this.tcpSender != null) {
            this.tcpSender.removeDeadConnection(this);
        }
    }

    @Override
    public long incrementAndGetConnectionSequence() {
        return this.theConnection.incrementAndGetConnectionSequence();
    }

    TcpSender getSender() {
        return this.tcpSender;
    }

    protected boolean hasRealSender() {
        if (this.realSender != null) {
            return this.realSender;
        }
        TcpSender sender = this.getSender();
        while (sender instanceof AbstractTcpConnectionInterceptor) {
            sender = ((AbstractTcpConnectionInterceptor)sender).getSender();
        }
        this.realSender = sender != null;
        return this.realSender;
    }
}

