/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.ip.tcp.connection.TcpNioConnection;
import org.springframework.integration.ip.tcp.connection.TcpNioConnectionSupport;
import org.springframework.integration.ip.tcp.connection.TcpNioSSLConnection;
import org.springframework.integration.ip.tcp.connection.support.TcpSSLContextSupport;
import org.springframework.util.Assert;

public class DefaultTcpNioSSLConnectionSupport
implements TcpNioConnectionSupport,
InitializingBean {
    private volatile SSLContext sslContext;
    private final TcpSSLContextSupport sslContextSupport;

    public DefaultTcpNioSSLConnectionSupport(TcpSSLContextSupport sslContextSupport) {
        Assert.notNull((Object)sslContextSupport, (String)"TcpSSLContextSupport must not be null");
        this.sslContextSupport = sslContextSupport;
    }

    public TcpNioConnection createNewConnection(SocketChannel socketChannel, boolean server, boolean lookupHost) throws Exception {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        TcpNioSSLConnection tcpNioSSLConnection = new TcpNioSSLConnection(socketChannel, server, lookupHost, sslEngine);
        tcpNioSSLConnection.init();
        return tcpNioSSLConnection;
    }

    public void afterPropertiesSet() throws Exception {
        this.sslContext = this.sslContextSupport.getSSLContext();
        Assert.notNull((Object)this.sslContext, (String)"SSLContex must not be null");
    }
}

