/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.IOException;
import java.net.Socket;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpNetConnection;
import org.springframework.integration.ip.tcp.connection.support.DefaultTcpNetSocketFactorySupport;
import org.springframework.integration.ip.tcp.connection.support.TcpSocketFactorySupport;
import org.springframework.util.Assert;

public class TcpNetClientConnectionFactory
extends AbstractClientConnectionFactory {
    private volatile TcpSocketFactorySupport tcpSocketFactorySupport = new DefaultTcpNetSocketFactorySupport();

    public TcpNetClientConnectionFactory(String host, int port) {
        super(host, port);
    }

    protected TcpConnection obtainConnection() throws Exception {
        TcpConnection theConnection = this.getTheConnection();
        if (theConnection != null && theConnection.isOpen()) {
            return theConnection;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opening new socket connection to " + this.getHost() + ":" + this.getPort()));
        }
        Socket socket = this.createSocket(this.getHost(), this.getPort());
        this.setSocketAttributes(socket);
        TcpConnection connection = new TcpNetConnection(socket, false, this.isLookupHost());
        connection = this.wrapConnection(connection);
        this.initializeConnection(connection, socket);
        this.getTaskExecutor().execute(connection);
        this.harvestClosedConnections();
        return connection;
    }

    public void start() {
        this.setActive(true);
        super.start();
    }

    protected Socket createSocket(String host, int port) throws IOException {
        return this.tcpSocketFactorySupport.getSocketFactory().createSocket(host, port);
    }

    public void close() {
    }

    protected TcpSocketFactorySupport getTcpSocketFactorySupport() {
        return this.tcpSocketFactorySupport;
    }

    public void setTcpSocketFactorySupport(TcpSocketFactorySupport tcpSocketFactorySupport) {
        Assert.notNull((Object)tcpSocketFactorySupport, (String)"TcpSocketFactorySupport may not be null");
        this.tcpSocketFactorySupport = tcpSocketFactorySupport;
    }
}

