/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import org.springframework.integration.ip.udp.UnicastSendingMessageHandler;

public class MulticastSendingMessageHandler
extends UnicastSendingMessageHandler {
    private int timeToLive = -1;
    private String localAddress;

    public MulticastSendingMessageHandler(String address, int port) {
        super(address, port);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck) {
        super(address, port, lengthCheck);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, acknowledge, ackHost, ackPort, ackTimeout);
    }

    public MulticastSendingMessageHandler(String address, int port, boolean lengthCheck, boolean acknowledge, String ackHost, int ackPort, int ackTimeout) {
        super(address, port, lengthCheck, acknowledge, ackHost, ackPort, ackTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatagramSocket getSocket() throws IOException {
        if (this.getTheSocket() == null) {
            MulticastSendingMessageHandler multicastSendingMessageHandler = this;
            synchronized (multicastSendingMessageHandler) {
                this.createSocket();
            }
        }
        return this.getTheSocket();
    }

    private void createSocket() throws IOException {
        if (this.getTheSocket() == null) {
            InetAddress whichNic;
            MulticastSocket socket;
            if (this.isAcknowledge()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Listening for acks on port: " + this.getAckPort()));
                }
                if (this.localAddress == null) {
                    socket = new MulticastSocket(this.getAckPort());
                } else {
                    whichNic = InetAddress.getByName(this.localAddress);
                    socket = new MulticastSocket(new InetSocketAddress(whichNic, this.getAckPort()));
                }
                if (this.getSoReceiveBufferSize() > 0) {
                    socket.setReceiveBufferSize(this.getSoReceiveBufferSize());
                }
            } else {
                socket = new MulticastSocket();
            }
            if (this.timeToLive >= 0) {
                socket.setTimeToLive(this.timeToLive);
            }
            this.setSocketAttributes(socket);
            if (this.localAddress != null) {
                whichNic = InetAddress.getByName(this.localAddress);
                NetworkInterface intfce = NetworkInterface.getByInetAddress(whichNic);
                socket.setNetworkInterface(intfce);
            }
            this.setSocket(socket);
        }
    }

    public void setMinAcksForSuccess(int minAcksForSuccess) {
        this.setAckCounter(minAcksForSuccess);
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }
}

