/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.springframework.context.Lifecycle;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpSender;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class TcpSendingMessageHandler
extends AbstractMessageHandler
implements TcpSender,
Lifecycle,
ClientModeCapable {
    private volatile AbstractConnectionFactory clientConnectionFactory;
    private volatile AbstractConnectionFactory serverConnectionFactory;
    private final Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();
    private volatile boolean isClientMode;
    private volatile long retryInterval = 60000L;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile ClientModeConnectionManager clientModeConnectionManager;
    protected final Object lifecycleMonitor = new Object();
    private volatile boolean active;

    protected TcpConnection obtainConnection(Message<?> message) {
        TcpConnection connection = null;
        Assert.notNull((Object)this.clientConnectionFactory, (String)"'clientConnectionFactory' cannot be null");
        try {
            connection = this.clientConnectionFactory.getConnection();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating connection", (Throwable)e);
            throw new MessageHandlingException(message, "Failed to obtain a connection", (Throwable)e);
        }
        return connection;
    }

    public void handleMessageInternal(Message<?> message) throws MessageHandlingException {
        if (this.serverConnectionFactory != null) {
            Object connectionId = message.getHeaders().get((Object)"ip_connectionId");
            TcpConnection connection = null;
            if (connectionId != null) {
                connection = this.connections.get(connectionId);
            }
            if (connection != null) {
                try {
                    connection.send(message);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error sending message", (Throwable)e);
                    connection.close();
                    if (e instanceof MessageHandlingException) {
                        throw (MessageHandlingException)((Object)e);
                    }
                    throw new MessageHandlingException(message, "Error sending message", (Throwable)e);
                }
            } else {
                this.logger.error((Object)("Unable to find outbound socket for " + message));
                throw new MessageHandlingException(message, "Unable to find outbound socket");
            }
            return;
        }
        try {
            this.doWrite(message);
        }
        catch (MessageHandlingException e) {
            if (e.getCause() instanceof IOException) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Fail on first write attempt", (Throwable)e);
                }
                this.doWrite(message);
            }
            throw e;
        }
    }

    protected void doWrite(Message<?> message) {
        TcpConnection connection = null;
        try {
            connection = this.obtainConnection(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got Connection " + connection.getConnectionId()));
            }
            connection.send(message);
        }
        catch (Exception e) {
            String connectionId = null;
            if (connection != null) {
                connectionId = connection.getConnectionId();
            }
            if (e instanceof MessageHandlingException) {
                throw (MessageHandlingException)((Object)e);
            }
            throw new MessageHandlingException(message, "Failed to handle message using " + connectionId, (Throwable)e);
        }
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
            connectionFactory.registerSender(this);
        }
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-outbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.active) {
                this.active = true;
                if (this.clientConnectionFactory != null) {
                    this.clientConnectionFactory.start();
                }
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.start();
                }
                if (this.isClientMode) {
                    ClientModeConnectionManager manager;
                    this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
                    Assert.state((this.getTaskScheduler() != null ? 1 : 0) != 0, (String)"Client mode requires a task scheduler");
                    this.scheduledFuture = this.getTaskScheduler().scheduleAtFixedRate((Runnable)manager, this.retryInterval);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(true);
                }
                if (this.clientConnectionFactory != null) {
                    this.clientConnectionFactory.stop();
                }
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.stop();
                }
            }
        }
    }

    public boolean isRunning() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(true);
                }
                this.clientModeConnectionManager = null;
                if (this.clientConnectionFactory != null) {
                    this.clientConnectionFactory.stop(callback);
                }
                if (this.serverConnectionFactory != null) {
                    this.serverConnectionFactory.stop(callback);
                }
            }
        }
    }

    protected ConnectionFactory getClientConnectionFactory() {
        return this.clientConnectionFactory;
    }

    protected ConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    protected Map<String, TcpConnection> getConnections() {
        return this.connections;
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        if (this.isClientMode && this.clientModeConnectionManager != null) {
            return this.clientModeConnectionManager.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        if (this.active && this.isClientMode && this.clientModeConnectionManager != null) {
            this.clientModeConnectionManager.run();
        }
    }
}

