/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.util.SimplePool;
import org.springframework.util.Assert;

public abstract class AbstractPooledBufferByteArraySerializer
extends AbstractByteArraySerializer {
    private SimplePool<byte[]> pool;
    private long poolWaitTimeout = Long.MAX_VALUE;

    public void setPoolSize(int size) {
        Assert.isNull(this.pool, (String)"Cannot change pool size once set");
        this.pool = new SimplePool(size, (SimplePool.PoolItemCallback)new SimplePool.PoolItemCallback<byte[]>(){

            public byte[] createForPool() {
                return new byte[AbstractPooledBufferByteArraySerializer.this.getMaxMessageSize()];
            }

            public boolean isStale(byte[] item) {
                return false;
            }

            public void removedFromPool(byte[] item) {
            }
        });
        this.pool.setWaitTimeout(this.poolWaitTimeout);
    }

    public void setPoolWaitTimeout(long poolWaitTimeout) {
        this.poolWaitTimeout = poolWaitTimeout;
        if (this.pool != null) {
            this.pool.setWaitTimeout(poolWaitTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] deserialize(InputStream inputStream) throws IOException {
        byte[] buffer = this.pool == null ? new byte[this.getMaxMessageSize()] : (byte[])this.pool.getItem();
        try {
            byte[] byArray = this.doDeserialize(inputStream, buffer);
            return byArray;
        }
        finally {
            if (this.pool != null) {
                this.pool.releaseItem((Object)buffer);
            }
        }
    }

    protected abstract byte[] doDeserialize(InputStream var1, byte[] var2) throws IOException;

    protected byte[] copyToSizedArray(byte[] buffer, int size) {
        if (size == buffer.length && this.pool == null) {
            return buffer;
        }
        byte[] assembledData = new byte[size];
        System.arraycopy(buffer, 0, assembledData, 0, size);
        return assembledData;
    }
}

