/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.expression.Expression;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.ExpressionEvaluatingCorrelationStrategy;
import org.springframework.integration.aggregator.ExpressionEvaluatingReleaseStrategy;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.config.CorrelationStrategyFactoryBean;
import org.springframework.integration.config.ReleaseStrategyFactoryBean;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.StringUtils;

public abstract class CorrelationHandlerSpec<S extends CorrelationHandlerSpec<S, H>, H extends AbstractCorrelatingMessageHandler>
extends MessageHandlerSpec<S, H> {
    protected MessageGroupStore messageStore;
    protected boolean sendPartialResultOnExpiry;
    private long minimumTimeoutForEmptyGroups;
    private Expression groupTimeoutExpression;
    private TaskScheduler taskScheduler;
    private MessageChannel discardChannel;
    private String discardChannelName;
    private CorrelationStrategy correlationStrategy;
    private ReleaseStrategy releaseStrategy;

    public S messageStore(MessageGroupStore messageStore) {
        this.messageStore = messageStore;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S sendPartialResultOnExpiry(boolean sendPartialResultOnExpiry) {
        this.sendPartialResultOnExpiry = sendPartialResultOnExpiry;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S minimumTimeoutForEmptyGroups(long minimumTimeoutForEmptyGroups) {
        this.minimumTimeoutForEmptyGroups = minimumTimeoutForEmptyGroups;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S groupTimeout(long groupTimeout) {
        this.groupTimeoutExpression = new ValueExpression((Object)groupTimeout);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S groupTimeoutExpression(String expression) {
        this.groupTimeoutExpression = PARSER.parseExpression(expression);
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S taskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S discardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S discardChannel(String discardChannelName) {
        this.discardChannelName = discardChannelName;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S processor(Object target, String methodName) {
        try {
            return ((CorrelationHandlerSpec)this.correlationStrategy(new CorrelationStrategyFactoryBean(target, methodName).getObject())).releaseStrategy(new ReleaseStrategyFactoryBean(target, methodName).getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S correlationExpression(String correlationExpression) {
        return this.correlationStrategy((CorrelationStrategy)new ExpressionEvaluatingCorrelationStrategy(correlationExpression));
    }

    public S correlationStrategy(Object target, String methodName) {
        try {
            return this.correlationStrategy(new CorrelationStrategyFactoryBean(target, methodName).getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S correlationStrategy(CorrelationStrategy correlationStrategy) {
        this.correlationStrategy = correlationStrategy;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    public S releaseExpression(String releaseExpression) {
        return this.releaseStrategy((ReleaseStrategy)new ExpressionEvaluatingReleaseStrategy(releaseExpression));
    }

    public S releaseStrategy(Object target, String methodName) {
        try {
            return this.releaseStrategy(new ReleaseStrategyFactoryBean(target, methodName).getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public S releaseStrategy(ReleaseStrategy releaseStrategy) {
        this.releaseStrategy = releaseStrategy;
        return (S)((CorrelationHandlerSpec)this._this());
    }

    protected H configure(H handler) {
        if (this.discardChannel != null) {
            handler.setDiscardChannel(this.discardChannel);
        }
        if (StringUtils.hasText((String)this.discardChannelName)) {
            handler.setDiscardChannelName(this.discardChannelName);
        }
        if (this.messageStore != null) {
            handler.setMessageStore(this.messageStore);
        }
        handler.setMinimumTimeoutForEmptyGroups(this.minimumTimeoutForEmptyGroups);
        handler.setGroupTimeoutExpression(this.groupTimeoutExpression);
        if (this.taskScheduler != null) {
            handler.setTaskScheduler(this.taskScheduler);
        }
        handler.setSendPartialResultOnExpiry(this.sendPartialResultOnExpiry);
        if (this.correlationStrategy != null) {
            handler.setCorrelationStrategy(this.correlationStrategy);
        }
        if (this.releaseStrategy != null) {
            handler.setReleaseStrategy(this.releaseStrategy);
        }
        return handler;
    }

    CorrelationHandlerSpec() {
    }
}

