/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.support.BeanNameMessageProcessor;
import org.springframework.integration.dsl.support.MapBuilder;
import org.springframework.integration.dsl.support.StringStringMapBuilder;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.transformer.HeaderEnricher;
import org.springframework.integration.transformer.support.ExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.StaticHeaderValueMessageProcessor;
import org.springframework.util.Assert;

public class HeaderEnricherSpec
extends IntegrationComponentSpec<HeaderEnricherSpec, HeaderEnricher> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final Map<String, HeaderValueMessageProcessor<?>> headerToAdd = new HashMap();
    private final HeaderEnricher headerEnricher = new HeaderEnricher(this.headerToAdd);

    HeaderEnricherSpec() {
    }

    public HeaderEnricherSpec defaultOverwrite(boolean defaultOverwrite) {
        this.headerEnricher.setDefaultOverwrite(defaultOverwrite);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec shouldSkipNulls(boolean shouldSkipNulls) {
        this.headerEnricher.setShouldSkipNulls(shouldSkipNulls);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(MessageProcessor<?> messageProcessor) {
        this.headerEnricher.setMessageProcessor(messageProcessor);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(String expression) {
        return this.messageProcessor((MessageProcessor<?>)new ExpressionEvaluatingMessageProcessor(PARSER.parseExpression(expression)));
    }

    public HeaderEnricherSpec messageProcessor(String beanName, String methodName) {
        return this.messageProcessor(new BeanNameMessageProcessor(beanName, methodName));
    }

    public HeaderEnricherSpec headers(MapBuilder<?, String, Object> headers) {
        return this.headers(headers.get());
    }

    public HeaderEnricherSpec headers(Map<String, Object> headers) {
        Assert.notNull(headers);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Expression) {
                this.header(name, (HeaderValueMessageProcessor)new ExpressionEvaluatingHeaderValueMessageProcessor((Expression)value, null));
                continue;
            }
            this.header(name, value);
        }
        return this;
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder<?, String, String> headers) {
        return this.headerExpressions(headers.get());
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder.MapBuilderConfigurer<StringStringMapBuilder, String, String> configurer) {
        StringStringMapBuilder builder = new StringStringMapBuilder();
        configurer.configure(builder);
        return this.headerExpressions(builder.get());
    }

    public HeaderEnricherSpec headerExpressions(Map<String, String> headers) {
        Assert.notNull(headers);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.header(entry.getKey(), (HeaderValueMessageProcessor)new ExpressionEvaluatingHeaderValueMessageProcessor(entry.getValue(), null));
        }
        return this;
    }

    public <V> HeaderEnricherSpec header(String name, V value) {
        return this.header(name, value, null);
    }

    public <V> HeaderEnricherSpec header(String name, V value, Boolean overwrite) {
        StaticHeaderValueMessageProcessor headerValueMessageProcessor = new StaticHeaderValueMessageProcessor(value);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor<V>)headerValueMessageProcessor);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression) {
        return this.headerExpression(name, expression, null);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression, Boolean overwrite) {
        ExpressionEvaluatingHeaderValueMessageProcessor headerValueMessageProcessor = new ExpressionEvaluatingHeaderValueMessageProcessor(expression, null);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor)headerValueMessageProcessor);
    }

    public <V> HeaderEnricherSpec header(String name, HeaderValueMessageProcessor<V> headerValueMessageProcessor) {
        Assert.notNull((Object)name);
        this.headerToAdd.put(name, headerValueMessageProcessor);
        return (HeaderEnricherSpec)this._this();
    }

    public <V> HeaderEnricherSpec headerChannelsToString() {
        return this.headerExpression("replyChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.replyChannel)", true).headerExpression("errorChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.errorChannel)", true);
    }

    @Override
    protected HeaderEnricher doGet() {
        return this.headerEnricher;
    }
}

