/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlowDefinition;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public abstract class IntegrationFlowAdapter
implements IntegrationFlow {
    @Override
    public final void configure(IntegrationFlowDefinition<?> flow) {
        IntegrationFlowDefinition<?> targetFlow = this.buildFlow();
        Assert.state((targetFlow != null ? 1 : 0) != 0, (String)"the 'buildFlow()' must not return null");
        flow.integrationComponents.clear();
        flow.integrationComponents.addAll(targetFlow.integrationComponents);
    }

    protected IntegrationFlowDefinition<?> from(String messageChannelName) {
        return IntegrationFlows.from(messageChannelName);
    }

    protected IntegrationFlowDefinition<?> from(MessageChannel messageChannel) {
        return IntegrationFlows.from(messageChannel);
    }

    protected IntegrationFlowDefinition<?> from(String messageChannelName, boolean fixedSubscriber) {
        return IntegrationFlows.from(messageChannelName, fixedSubscriber);
    }

    protected IntegrationFlowDefinition<?> from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(messageSourceSpec, endpointConfigurer);
    }

    protected IntegrationFlowDefinition<?> from(MessageSource<?> messageSource, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(messageSource, endpointConfigurer);
    }

    protected IntegrationFlowDefinition<?> from(IntegrationFlows.MessageSourcesFunction sources, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(sources, endpointConfigurer);
    }

    protected IntegrationFlowDefinition<?> from(IntegrationFlows.ChannelsFunction channels) {
        return IntegrationFlows.from(channels);
    }

    protected IntegrationFlowDefinition<?> from(MessageProducerSupport messageProducer) {
        return IntegrationFlows.from(messageProducer);
    }

    protected IntegrationFlowDefinition<?> from(MessageSource<?> messageSource) {
        return IntegrationFlows.from(messageSource);
    }

    protected IntegrationFlowDefinition<?> from(IntegrationFlows.MessageSourcesFunction sources) {
        return IntegrationFlows.from(sources);
    }

    protected IntegrationFlowDefinition<?> from(MessagingGatewaySupport inboundGateway) {
        return IntegrationFlows.from(inboundGateway);
    }

    protected IntegrationFlowDefinition<?> from(MessageChannelSpec<?, ?> messageChannelSpec) {
        return IntegrationFlows.from(messageChannelSpec);
    }

    protected IntegrationFlowDefinition<?> from(IntegrationFlows.MessageProducersFunction producers) {
        return IntegrationFlows.from(producers);
    }

    protected IntegrationFlowDefinition<?> from(MessageProducerSpec<?, ?> messageProducerSpec) {
        return IntegrationFlows.from(messageProducerSpec);
    }

    protected IntegrationFlowDefinition<?> from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec) {
        return IntegrationFlows.from(messageSourceSpec);
    }

    protected IntegrationFlowDefinition<?> from(MessagingGatewaySpec<?, ?> inboundGatewaySpec) {
        return IntegrationFlows.from(inboundGatewaySpec);
    }

    protected IntegrationFlowDefinition<?> from(IntegrationFlows.MessagingGatewaysFunction gateways) {
        return IntegrationFlows.from(gateways);
    }

    public static IntegrationFlowBuilder from(Object service, String methodName) {
        return IntegrationFlows.from(service, methodName);
    }

    public static IntegrationFlowBuilder from(Object service, String methodName, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(service, methodName, endpointConfigurer);
    }

    protected abstract IntegrationFlowDefinition<?> buildFlow();
}

