/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.JdbcOutboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JdbcOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        String updateQuery;
        String selectQuery;
        String dataSourceRef = element.getAttribute("data-source");
        String jdbcOperationsRef = element.getAttribute("jdbc-operations");
        boolean refToDataSourceSet = StringUtils.hasText((String)dataSourceRef);
        boolean refToJdbcOperationsSet = StringUtils.hasText((String)jdbcOperationsRef);
        if (refToDataSourceSet && refToJdbcOperationsSet || !refToDataSourceSet && !refToJdbcOperationsSet) {
            parserContext.getReaderContext().error("Exactly one of the attributes data-source or simple-jdbc-operations should be set for the JDBC outbound-gateway", (Object)element);
        }
        if (!StringUtils.hasText((String)(selectQuery = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"query", (ParserContext)parserContext)))) {
            selectQuery = null;
        }
        if (!StringUtils.hasText((String)(updateQuery = IntegrationNamespaceUtils.getTextFromAttributeOrNestedElement((Element)element, (String)"update", (ParserContext)parserContext)))) {
            parserContext.getReaderContext().error("The update attribute is required", (Object)element);
            return null;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcOutboundGateway.class);
        if (refToDataSourceSet) {
            builder.addConstructorArgReference(dataSourceRef);
        } else {
            builder.addConstructorArgReference(jdbcOperationsRef);
        }
        builder.getRawBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)updateQuery);
        builder.getRawBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)selectQuery);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-sql-parameter-source-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-sql-parameter-source-factory");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"row-mapper");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"max-rows-per-poll");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"keys-generated");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        String replyChannel = element.getAttribute("reply-channel");
        if (StringUtils.hasText((String)replyChannel)) {
            builder.addPropertyReference("outputChannel", replyChannel);
        }
        return builder;
    }

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }
}

