/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.StoredProcMessageHandler;
import org.springframework.integration.jdbc.config.StoredProcParserUtils;
import org.w3c.dom.Element;

public class StoredProcMessageHandlerParser
extends AbstractOutboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StoredProcMessageHandler.class);
        String dataSourceRef = element.getAttribute("data-source");
        String storedProcedureName = element.getAttribute("stored-procedure-name");
        builder.addConstructorArgReference(dataSourceRef);
        builder.addConstructorArgValue((Object)storedProcedureName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"ignore-column-meta-data");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"use-payload-as-parameter-source");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"sql-parameter-source-factory");
        ManagedList<BeanDefinition> procedureParameterList = StoredProcParserUtils.getProcedureParameterBeanDefinitions(element, parserContext);
        ManagedList<BeanDefinition> sqlParameterDefinitionList = StoredProcParserUtils.getSqlParameterDefinitionBeanDefinitions(element, parserContext);
        if (!procedureParameterList.isEmpty()) {
            builder.addPropertyValue("procedureParameters", procedureParameterList);
        }
        if (!sqlParameterDefinitionList.isEmpty()) {
            builder.addPropertyValue("sqlParameters", sqlParameterDefinitionList);
        }
        return builder.getBeanDefinition();
    }
}

