/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.jdbc.config.JdbcTypesEnum;
import org.springframework.integration.jdbc.storedproc.ProcedureParameter;
import org.springframework.jdbc.core.SqlInOutParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoredProcParserUtils {
    private static final Log LOGGER = LogFactory.getLog(StoredProcParserUtils.class);

    private StoredProcParserUtils() {
        throw new AssertionError();
    }

    public static ManagedList<BeanDefinition> getSqlParameterDefinitionBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        List sqlParameterDefinitionChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"sql-parameter-definition");
        ManagedList sqlParameterList = new ManagedList();
        for (Element childElement : sqlParameterDefinitionChildElements) {
            String name = childElement.getAttribute("name");
            String sqlType = childElement.getAttribute("type");
            String direction = childElement.getAttribute("direction");
            String scale = childElement.getAttribute("scale");
            BeanDefinitionBuilder parameterBuilder = "OUT".equalsIgnoreCase(direction) ? BeanDefinitionBuilder.genericBeanDefinition(SqlOutParameter.class) : ("INOUT".equalsIgnoreCase(direction) ? BeanDefinitionBuilder.genericBeanDefinition(SqlInOutParameter.class) : BeanDefinitionBuilder.genericBeanDefinition(SqlParameter.class));
            if (StringUtils.hasText((String)name)) {
                parameterBuilder.addConstructorArgValue((Object)name);
            } else {
                parserContext.getReaderContext().error("The 'name' attribute must be set for the Sql parameter element.", (Object)storedProcComponent);
            }
            if (StringUtils.hasText((String)sqlType)) {
                JdbcTypesEnum jdbcTypeEnum = JdbcTypesEnum.convertToJdbcTypesEnum(sqlType);
                if (jdbcTypeEnum != null) {
                    parameterBuilder.addConstructorArgValue((Object)jdbcTypeEnum.getCode());
                } else {
                    parameterBuilder.addConstructorArgValue((Object)sqlType);
                }
            } else {
                parameterBuilder.addConstructorArgValue((Object)12);
            }
            if (StringUtils.hasText((String)scale)) {
                parameterBuilder.addConstructorArgValue((Object)new TypedStringValue(scale, Integer.class));
            }
            sqlParameterList.add((Object)parameterBuilder.getBeanDefinition());
        }
        return sqlParameterList;
    }

    public static ManagedList<BeanDefinition> getProcedureParameterBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        ManagedList procedureParameterList = new ManagedList();
        List parameterChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"parameter");
        for (Element childElement : parameterChildElements) {
            BeanDefinitionBuilder parameterBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProcedureParameter.class);
            String name = childElement.getAttribute("name");
            String expression = childElement.getAttribute("expression");
            String value = childElement.getAttribute("value");
            String type = childElement.getAttribute("type");
            if (StringUtils.hasText((String)name)) {
                parameterBuilder.addPropertyValue("name", (Object)name);
            }
            if (StringUtils.hasText((String)expression)) {
                parameterBuilder.addPropertyValue("expression", (Object)expression);
            }
            if (StringUtils.hasText((String)value)) {
                if (!StringUtils.hasText((String)type)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)String.format("Type attribute not set for Store Procedure parameter '%s'. Defaulting to 'java.lang.String'.", value));
                    }
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, String.class));
                } else {
                    parameterBuilder.addPropertyValue("value", (Object)new TypedStringValue(value, type));
                }
            }
            procedureParameterList.add((Object)parameterBuilder.getBeanDefinition());
        }
        return procedureParameterList;
    }

    public static ManagedMap<String, BeanDefinition> getReturningResultsetBeanDefinitions(Element storedProcComponent, ParserContext parserContext) {
        List returningResultsetChildElements = DomUtils.getChildElementsByTagName((Element)storedProcComponent, (String)"returning-resultset");
        ManagedMap returningResultsetMap = new ManagedMap();
        for (Element childElement : returningResultsetChildElements) {
            String name = childElement.getAttribute("name");
            String rowMapperAsString = childElement.getAttribute("row-mapper");
            if (!StringUtils.hasText((String)name)) {
                parserContext.getReaderContext().error("The 'name' attribute must be set for the 'returning-resultset' element.", (Object)storedProcComponent);
            }
            if (!StringUtils.hasText((String)rowMapperAsString)) {
                parserContext.getReaderContext().error("The 'row-mapper' attribute must be set for the 'returning-resultset' element.", (Object)storedProcComponent);
            }
            BeanDefinitionBuilder rowMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)rowMapperAsString);
            returningResultsetMap.put((Object)name, (Object)rowMapperBuilder.getBeanDefinition());
        }
        return returningResultsetMap;
    }
}

