/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.util.Assert;

public class StoredProcMessageHandler
extends AbstractMessageHandler
implements InitializingBean {
    private final StoredProcExecutor executor;

    public StoredProcMessageHandler(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    protected void handleMessageInternal(Message<?> message) {
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(message);
        if (this.logger.isDebugEnabled() && resultMap != null && !resultMap.isEmpty()) {
            this.logger.debug((Object)String.format("The StoredProcMessageHandler ignores return values, but the called Stored Procedure '%s' returned data: '%s'", this.executor.getStoredProcedureName(), resultMap));
        }
    }
}

