/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.jdbc.store.channel.ChannelMessageStoreQueryProvider;
import org.springframework.integration.jdbc.store.channel.MessageRowMapper;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ManagedResource
public class JdbcChannelMessageStore
implements PriorityCapableChannelMessageStore,
InitializingBean,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(JdbcChannelMessageStore.class);
    private final Set<String> idCache = new HashSet<String>();
    private final ReadWriteLock idCacheLock = new ReentrantReadWriteLock();
    private final Lock idCacheReadLock = this.idCacheLock.readLock();
    private final Lock idCacheWriteLock = this.idCacheLock.writeLock();
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    public static final String DEFAULT_REGION = "DEFAULT";
    private ChannelMessageStoreQueryProvider channelMessageStoreQueryProvider;
    public static final String SAVED_KEY = JdbcChannelMessageStore.class.getSimpleName() + ".SAVED";
    public static final String CREATED_DATE_KEY = JdbcChannelMessageStore.class.getSimpleName() + ".CREATED_DATE";
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile String region = "DEFAULT";
    private volatile String tablePrefix = "INT_";
    private volatile JdbcTemplate jdbcTemplate;
    private volatile DeserializingConverter deserializer;
    private volatile SerializingConverter serializer;
    private volatile LobHandler lobHandler = new DefaultLobHandler();
    private volatile MessageRowMapper messageRowMapper;
    private volatile Map<String, String> queryCache = new HashMap<String, String>();
    private boolean usingIdCache = false;
    private boolean priorityEnabled;

    public JdbcChannelMessageStore() {
        this.deserializer = new DeserializingConverter();
        this.serializer = new SerializingConverter();
    }

    public JdbcChannelMessageStore(DataSource dataSource) {
        this();
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.setFetchSize(1);
        this.jdbcTemplate.setMaxRows(1);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.setFetchSize(1);
        this.jdbcTemplate.setMaxRows(1);
    }

    public void setDeserializer(Deserializer<? extends Message<?>> deserializer) {
        this.deserializer = new DeserializingConverter(deserializer);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"The provided jdbcTemplate must not be null.");
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"The provided LobHandler must not be null.");
        this.lobHandler = lobHandler;
    }

    public void setMessageRowMapper(MessageRowMapper messageRowMapper) {
        Assert.notNull((Object)messageRowMapper, (String)"The provided MessageRowMapper must not be null.");
        this.messageRowMapper = messageRowMapper;
    }

    public void setChannelMessageStoreQueryProvider(ChannelMessageStoreQueryProvider channelMessageStoreQueryProvider) {
        Assert.notNull((Object)channelMessageStoreQueryProvider, (String)"The provided channelMessageStoreQueryProvider must not be null.");
        this.channelMessageStoreQueryProvider = channelMessageStoreQueryProvider;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSerializer(Serializer<? super Message<?>> serializer) {
        Assert.notNull(serializer, (String)"The provided serializer must not be null.");
        this.serializer = new SerializingConverter(serializer);
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setUsingIdCache(boolean usingIdCache) {
        this.usingIdCache = usingIdCache;
    }

    public void setPriorityEnabled(boolean priorityEnabled) {
        this.priorityEnabled = priorityEnabled;
    }

    public boolean isPriorityEnabled() {
        return this.priorityEnabled;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)beanFactory);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jdbcTemplate != null ? 1 : 0) != 0, (String)"A DataSource or JdbcTemplate must be provided");
        Assert.notNull((Object)this.channelMessageStoreQueryProvider, (String)"A channelMessageStoreQueryProvider must be provided.");
        if (this.messageRowMapper == null) {
            this.messageRowMapper = new MessageRowMapper(this.deserializer, this.lobHandler);
        }
        if (this.jdbcTemplate.getFetchSize() != 1 && logger.isWarnEnabled()) {
            logger.warn((Object)"The jdbcTemplate's fetchsize is not 1. This may cause FIFO issues with Oracle databases.");
        }
        this.jdbcTemplate.afterPropertiesSet();
    }

    public MessageGroup addMessageToGroup(Object groupId, final Message<?> message) {
        final String groupKey = this.getKey(groupId);
        final long createdDate = System.currentTimeMillis();
        Message result = this.messageBuilderFactory.fromMessage(message).setHeader(SAVED_KEY, (Object)Boolean.TRUE).setHeader(CREATED_DATE_KEY, (Object)createdDate).build();
        Map innerMap = (Map)new DirectFieldAccessor((Object)result.getHeaders()).getPropertyValue("headers");
        innerMap.put("id", message.getHeaders().get((Object)"id"));
        final String messageId = this.getKey(result.getHeaders().getId());
        final byte[] messageBytes = this.serializer.convert((Object)result);
        this.jdbcTemplate.update(this.getQuery(this.channelMessageStoreQueryProvider.getCreateMessageQuery()), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Inserting message with id key=" + messageId));
                }
                ps.setString(1, messageId);
                ps.setString(2, groupKey);
                ps.setString(3, JdbcChannelMessageStore.this.region);
                ps.setLong(4, createdDate);
                Integer priority = new IntegrationMessageHeaderAccessor(message).getPriority();
                if (JdbcChannelMessageStore.this.priorityEnabled && priority != null) {
                    ps.setInt(5, priority);
                } else {
                    ps.setNull(5, 2);
                }
                JdbcChannelMessageStore.this.lobHandler.getLobCreator().setBlobAsBytes(ps, 6, messageBytes);
            }
        });
        return this.getMessageGroup(groupId);
    }

    private String getKey(Object input) {
        return input == null ? null : UUIDConverter.getUUID((Object)input).toString();
    }

    public MessageGroup getMessageGroup(Object groupId) {
        return new SimpleMessageGroup(groupId);
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery("SELECT COUNT(DISTINCT GROUP_KEY) from %PREFIX%CHANNEL_MESSAGE where REGION = ?"), Integer.class, new Object[]{this.region});
    }

    protected String getQuery(String sqlQuery) {
        String query = this.queryCache.get(sqlQuery);
        if (query == null) {
            query = StringUtils.replace((String)sqlQuery, (String)"%PREFIX%", (String)this.tablePrefix);
            this.queryCache.put(sqlQuery, query);
        }
        return query;
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        String key = this.getKey(groupId);
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(this.channelMessageStoreQueryProvider.getCountAllMessagesInGroupQuery()), Integer.class, new Object[]{key, this.region});
    }

    public void removeMessageGroup(Object groupId) {
        this.jdbcTemplate.update(this.getQuery(this.channelMessageStoreQueryProvider.getDeleteMessageGroupQuery()), new Object[]{this.getKey(groupId), this.region});
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        String key = this.getKey(groupId);
        Message<?> polledMessage = this.doPollForMessage(key);
        if (polledMessage != null && !this.doRemoveMessageFromGroup(groupId, polledMessage)) {
            return null;
        }
        return polledMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message<?> doPollForMessage(String groupIdKey) {
        List messages;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("region", (Object)this.region);
        parameters.addValue("group_key", (Object)groupIdKey);
        this.idCacheReadLock.lock();
        try {
            String query;
            if (this.usingIdCache && !this.idCache.isEmpty()) {
                query = this.priorityEnabled ? this.getQuery(this.channelMessageStoreQueryProvider.getPriorityPollFromGroupExcludeIdsQuery()) : this.getQuery(this.channelMessageStoreQueryProvider.getPollFromGroupExcludeIdsQuery());
                parameters.addValue("message_ids", this.idCache);
            } else {
                query = this.priorityEnabled ? this.getQuery(this.channelMessageStoreQueryProvider.getPriorityPollFromGroupQuery()) : this.getQuery(this.channelMessageStoreQueryProvider.getPollFromGroupQuery());
            }
            messages = namedParameterJdbcTemplate.query(query, (SqlParameterSource)parameters, (RowMapper)this.messageRowMapper);
        }
        finally {
            this.idCacheReadLock.unlock();
        }
        Assert.isTrue((messages.size() == 0 || messages.size() == 1 ? 1 : 0) != 0);
        if (messages.size() > 0) {
            Message message = (Message)messages.get(0);
            String messageId = message.getHeaders().getId().toString();
            if (this.usingIdCache) {
                this.idCacheWriteLock.lock();
                try {
                    boolean added = this.idCache.add(messageId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Polled message with id '%s' added: '%s'.", messageId, added));
                    }
                }
                finally {
                    this.idCacheWriteLock.unlock();
                }
            }
            return message;
        }
        return null;
    }

    private boolean doRemoveMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        boolean result;
        UUID id = messageToRemove.getHeaders().getId();
        int updated = this.jdbcTemplate.update(this.getQuery(this.channelMessageStoreQueryProvider.getDeleteMessageQuery()), new Object[]{this.getKey(id), this.getKey(groupId), this.region}, new int[]{12, 12, 12});
        boolean bl = result = updated != 0;
        if (result) {
            logger.debug((Object)String.format("Message with id '%s' was deleted.", id));
        } else {
            logger.warn((Object)String.format("Message with id '%s' was not deleted.", id));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromIdCache(String messageId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing Message Id:" + messageId));
        }
        this.idCacheWriteLock.lock();
        try {
            this.idCache.remove(messageId);
        }
        finally {
            this.idCacheWriteLock.unlock();
        }
    }

    @ManagedMetric
    public int getSizeOfIdCache() {
        return this.idCache.size();
    }
}

