/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.messaging.Message;

public class JdbcPollingChannelAdapter
extends IntegrationObjectSupport
implements MessageSource<Object> {
    private final NamedParameterJdbcOperations jdbcOperations;
    private final String selectQuery;
    private volatile RowMapper<?> rowMapper;
    private volatile SqlParameterSource sqlQueryParameterSource;
    private volatile boolean updatePerRow = false;
    private volatile String updateSql;
    private volatile SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private volatile boolean sqlParameterSourceFactorySet;
    private volatile int maxRowsPerPoll = 0;

    public JdbcPollingChannelAdapter(DataSource dataSource, String selectQuery) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(dataSource);
        this.selectQuery = selectQuery;
    }

    public JdbcPollingChannelAdapter(JdbcOperations jdbcOperations, String selectQuery) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations);
        this.selectQuery = selectQuery;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setUpdatePerRow(boolean updatePerRow) {
        this.updatePerRow = updatePerRow;
    }

    public void setUpdateSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
        this.sqlParameterSourceFactorySet = true;
    }

    public void setSelectSqlParameterSource(SqlParameterSource sqlQueryParameterSource) {
        this.sqlQueryParameterSource = sqlQueryParameterSource;
    }

    public void setMaxRowsPerPoll(int maxRows) {
        this.maxRowsPerPoll = maxRows;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (!this.sqlParameterSourceFactorySet && this.getBeanFactory() != null) {
            ((ExpressionEvaluatingSqlParameterSourceFactory)this.sqlParameterSourceFactory).setBeanFactory(this.getBeanFactory());
        }
    }

    public Message<Object> receive() {
        Object payload = this.poll();
        if (payload == null) {
            return null;
        }
        return this.getMessageBuilderFactory().withPayload(payload).build();
    }

    private Object poll() {
        List<?> payload = this.doPoll(this.sqlQueryParameterSource);
        if (payload.size() < 1) {
            payload = null;
        }
        if (payload != null && this.updateSql != null) {
            if (this.updatePerRow) {
                for (Object row : payload) {
                    this.executeUpdateQuery(row);
                }
            } else {
                this.executeUpdateQuery(payload);
            }
        }
        return payload;
    }

    private void executeUpdateQuery(Object obj) {
        SqlParameterSource updateParamaterSource = this.sqlParameterSourceFactory.createParameterSource(obj);
        this.jdbcOperations.update(this.updateSql, updateParamaterSource);
    }

    protected List<?> doPoll(SqlParameterSource sqlQueryParameterSource) {
        ResultSetExtractor<List<Object>> resultSetExtractor;
        ColumnMapRowMapper rowMapper;
        List payload = null;
        ColumnMapRowMapper columnMapRowMapper = rowMapper = this.rowMapper == null ? new ColumnMapRowMapper() : this.rowMapper;
        if (this.maxRowsPerPoll > 0) {
            resultSetExtractor = new ResultSetExtractor<List<Object>>((RowMapper)rowMapper){
                final /* synthetic */ RowMapper val$rowMapper;
                {
                    this.val$rowMapper = rowMapper;
                }

                public List<Object> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<Object> results = new ArrayList<Object>(JdbcPollingChannelAdapter.this.maxRowsPerPoll);
                    int rowNum = 0;
                    while (rs.next() && rowNum < JdbcPollingChannelAdapter.this.maxRowsPerPoll) {
                        results.add(this.val$rowMapper.mapRow(rs, rowNum++));
                    }
                    return results;
                }
            };
        } else {
            RowMapperResultSetExtractor temp = new RowMapperResultSetExtractor((RowMapper)rowMapper);
            resultSetExtractor = temp;
        }
        payload = sqlQueryParameterSource != null ? (List)this.jdbcOperations.query(this.selectQuery, sqlQueryParameterSource, (ResultSetExtractor)resultSetExtractor) : (List)this.jdbcOperations.getJdbcOperations().query(this.selectQuery, (ResultSetExtractor)resultSetExtractor);
        return payload;
    }

    public String getComponentType() {
        return "jdbc:inbound-channel-adapter";
    }
}

