/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.core.PollableChannel;
import org.springframework.integration.jms.AbstractJmsChannel;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.jms.core.JmsTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollableJmsChannel
extends AbstractJmsChannel
implements PollableChannel {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public PollableJmsChannel(JmsTemplate jmsTemplate) {
        super(jmsTemplate);
    }

    public Message<?> receive() {
        Object object = this.getJmsTemplate().receiveAndConvert();
        if (object == null) {
            return null;
        }
        if (object instanceof Message) {
            return (Message)object;
        }
        return MessageBuilder.withPayload((Object)object).build();
    }

    public Message<?> receive(long timeout) {
        if (this.logger.isWarnEnabled() && this.timeoutConflictsWithTemplateValue(timeout)) {
            this.logger.warn((Object)("The JmsTemplate's receiveTimeout value is always used for the JMS channel. Its current value is " + this.getJmsTemplate().getReceiveTimeout() + ". The passed value of " + timeout + " will be ignored."));
        }
        return this.receive();
    }

    private boolean timeoutConflictsWithTemplateValue(long timeout) {
        long templateTimeout = this.getJmsTemplate().getReceiveTimeout();
        return timeout == -1L && templateTimeout != 0L || timeout == 0L && templateTimeout != -1L || timeout != templateTimeout;
    }
}

