/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.integration.Message;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJmsChannel
extends AbstractMessageChannel {
    private final JmsTemplate jmsTemplate;

    public AbstractJmsChannel(JmsTemplate jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"jmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
    }

    JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    protected boolean doSend(Message<?> message, long timeout) {
        this.jmsTemplate.convertAndSend(message);
        return true;
    }
}

