/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.config;

import javax.management.MBeanServerFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MBeanExporterParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.monitor.IntegrationMBeanExporter";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Object mbeanServer = this.getMBeanServer(element, parserContext);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-domain");
        builder.addPropertyValue("server", mbeanServer);
    }

    private Object getMBeanServer(Element element, ParserContext parserContext) {
        String mbeanServer = element.getAttribute("server");
        if (StringUtils.hasText((String)mbeanServer)) {
            return new RuntimeBeanReference(mbeanServer);
        }
        return MBeanServerFactory.createMBeanServer();
    }
}

