/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionEvaluatingParameterSourceUtils {
    private ExpressionEvaluatingParameterSourceUtils() {
        throw new AssertionError();
    }

    public static Map<String, String> convertExpressions(Collection<JpaParameter> jpaParameters) {
        Assert.notNull(jpaParameters, (String)"The Collection of jpaParameters must not be null.");
        for (JpaParameter parameter : jpaParameters) {
            Assert.notNull((Object)parameter, (String)"'jpaParameters' must not contain null values.");
        }
        HashMap<String, String> staticParameters = new HashMap<String, String>();
        for (JpaParameter parameter : jpaParameters) {
            if (parameter.getExpression() == null) continue;
            staticParameters.put(parameter.getName(), parameter.getExpression());
        }
        return staticParameters;
    }

    public static Map<String, Object> convertStaticParameters(Collection<JpaParameter> jpaParameters) {
        Assert.notNull(jpaParameters, (String)"The Collection of jpaParameters must not be null.");
        for (JpaParameter parameter : jpaParameters) {
            Assert.notNull((Object)parameter, (String)"'jpaParameters' must not contain null values.");
        }
        HashMap<String, Object> staticParameters = new HashMap<String, Object>();
        for (JpaParameter parameter : jpaParameters) {
            if (parameter.getValue() == null) continue;
            staticParameters.put(parameter.getName(), parameter.getValue());
        }
        return staticParameters;
    }

    public static class ParameterExpressionEvaluator
    extends AbstractExpressionEvaluator {
        public StandardEvaluationContext getEvaluationContext() {
            return super.getEvaluationContext();
        }

        public Object evaluateExpression(String expression, Object input) {
            return super.evaluateExpression(expression, input);
        }
    }
}

