/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.integration.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class KafkaMessageDrivenChannelAdapterParser
extends AbstractChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(KafkaMessageDrivenChannelAdapter.class);
        String container = element.getAttribute("listener-container");
        String connectionFactory = element.getAttribute("connection-factory");
        String topics = element.getAttribute("topics");
        String offsetManager = element.getAttribute("offset-manager");
        String errorHandler = element.getAttribute("error-handler");
        String taskExecutor = element.getAttribute("task-executor");
        String concurrency = element.getAttribute("concurrency");
        String stopTimeout = element.getAttribute("stop-timeout");
        String maxFetch = element.getAttribute("max-fetch");
        String queueSize = element.getAttribute("queue-size");
        if (StringUtils.hasText((String)container) && (StringUtils.hasText((String)connectionFactory) || StringUtils.hasText((String)topics) || StringUtils.hasText((String)offsetManager) || StringUtils.hasText((String)errorHandler) || StringUtils.hasText((String)taskExecutor) || StringUtils.hasText((String)concurrency) || StringUtils.hasText((String)maxFetch) || StringUtils.hasText((String)queueSize) || StringUtils.hasText((String)stopTimeout))) {
            parserContext.getReaderContext().error("The 'listener-container' is mutually exclusive with 'connection-factory', 'topics', 'offset-manager', 'error-handler', 'task-executor', 'concurrency', 'stop-timeout', 'max-fetch' and 'queue-size'.", (Object)element);
        }
        if (StringUtils.hasText((String)container)) {
            builder.addConstructorArgReference(container);
        } else {
            if (!StringUtils.hasText((String)connectionFactory)) {
                parserContext.getReaderContext().error("The 'connection-factory' attribute is required when 'listener-container' isn't provided.", (Object)element);
            }
            if (!StringUtils.hasText((String)topics)) {
                parserContext.getReaderContext().error("The 'topics' attribute is required when 'listener-container' isn't provided.", (Object)element);
            }
            BeanDefinitionBuilder containerBuilder = BeanDefinitionBuilder.genericBeanDefinition(KafkaMessageListenerContainer.class);
            containerBuilder.addConstructorArgReference(connectionFactory).addConstructorArgValue((Object)topics);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"offset-manager");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"error-handler");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"task-executor", (String)"fetchTaskExecutor");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"concurrency");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"max-fetch");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"stop-timeout");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)containerBuilder, (Element)element, (String)"queue-size");
            builder.addConstructorArgValue((Object)containerBuilder.getBeanDefinition());
        }
        builder.addPropertyReference("outputChannel", channelName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"key-decoder");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"payload-decoder");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-commit", (String)"autoCommitOffset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"use-context-message-builder", (String)"useMessageBuilderFactory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"set-id", (String)"generateMessageId");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"set-timestamp", (String)"generateTimestamp");
        return builder.getBeanDefinition();
    }
}

