/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.util;

import java.util.List;
import java.util.Properties;
import kafka.admin.AdminUtils;
import kafka.api.TopicMetadata;
import kafka.common.ErrorMapping;
import kafka.javaapi.PartitionMetadata;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.kafka.core.TopicNotFoundException;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.policy.TimeoutRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import scala.collection.Map;
import scala.collection.Seq;

public class TopicUtils {
    private static Log log = LogFactory.getLog(TopicUtils.class);
    public static final int METADATA_VERIFICATION_TIMEOUT = 5000;
    public static final int METADATA_VERIFICATION_RETRY_ATTEMPTS = 10;
    public static final double METADATA_VERIFICATION_RETRY_BACKOFF_MULTIPLIER = 1.5;
    public static final int METADATA_VERIFICATION_RETRY_INITIAL_INTERVAL = 100;
    public static final int METADATA_VERIFICATION_MAX_INTERVAL = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TopicMetadata ensureTopicCreated(String zkAddress, String topicName, int numPartitions, int replicationFactor) {
        int sessionTimeoutMs = 10000;
        int connectionTimeoutMs = 10000;
        try (ZkClient zkClient = new ZkClient(zkAddress, 10000, 10000, (ZkSerializer)ZKStringSerializer$.MODULE$);){
            Properties topicConfig = new Properties();
            Seq brokerList = ZkUtils.getSortedBrokerList((ZkClient)zkClient);
            Map replicaAssignment = AdminUtils.assignReplicasToBrokers((Seq)brokerList, (int)numPartitions, (int)replicationFactor, (int)-1, (int)-1);
            TopicMetadata topicMetadata = TopicUtils.ensureTopicCreated(zkClient, topicName, numPartitions, topicConfig, (Map<Object, Seq<Object>>)replicaAssignment);
            return topicMetadata;
        }
    }

    public static TopicMetadata ensureTopicCreated(final ZkClient zkClient, final String topicName, final int numPartitions, Properties topicConfig, Map<Object, Seq<Object>> replicaAssignment) {
        AdminUtils.createOrUpdateTopicPartitionAssignmentPathInZK((ZkClient)zkClient, (String)topicName, replicaAssignment, (Properties)topicConfig, (boolean)true);
        RetryTemplate retryTemplate = new RetryTemplate();
        CompositeRetryPolicy policy = new CompositeRetryPolicy();
        TimeoutRetryPolicy timeoutRetryPolicy = new TimeoutRetryPolicy();
        timeoutRetryPolicy.setTimeout(5000L);
        SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy();
        simpleRetryPolicy.setMaxAttempts(10);
        policy.setPolicies(new RetryPolicy[]{timeoutRetryPolicy, simpleRetryPolicy});
        retryTemplate.setRetryPolicy((RetryPolicy)policy);
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(100L);
        backOffPolicy.setMultiplier(1.5);
        backOffPolicy.setMaxInterval(1000L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        try {
            return (TopicMetadata)retryTemplate.execute((RetryCallback)new RetryCallback<TopicMetadata, Exception>(){

                public TopicMetadata doWithRetry(RetryContext context) throws Exception {
                    TopicMetadata topicMetadata = AdminUtils.fetchTopicMetadataFromZk((String)topicName, (ZkClient)zkClient);
                    if (topicMetadata.errorCode() != ErrorMapping.NoError() || !topicName.equals(topicMetadata.topic())) {
                        throw (Exception)ErrorMapping.exceptionFor((short)topicMetadata.errorCode());
                    }
                    List partitionMetadatas = new kafka.javaapi.TopicMetadata(topicMetadata).partitionsMetadata();
                    if (partitionMetadatas.size() != numPartitions) {
                        throw new IllegalStateException("The number of expected partitions was: " + numPartitions + ", but " + partitionMetadatas.size() + " have been found instead");
                    }
                    for (PartitionMetadata partitionMetadata : partitionMetadatas) {
                        if (partitionMetadata.errorCode() == ErrorMapping.NoError()) continue;
                        throw (Exception)ErrorMapping.exceptionFor((short)partitionMetadata.errorCode());
                    }
                    return topicMetadata;
                }
            });
        }
        catch (Exception e) {
            log.error((Object)String.format("Cannot retrieve metadata for topic '%s'", topicName), (Throwable)e);
            throw new TopicNotFoundException(topicName);
        }
    }
}

