/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.URLName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class MailTransportUtils {
    private static final Log logger = LogFactory.getLog(MailTransportUtils.class);

    public static void closeService(Service service) {
        if (service != null) {
            try {
                service.close();
            }
            catch (MessagingException ex) {
                logger.debug((Object)"Could not close JavaMail Service", (Throwable)ex);
            }
        }
    }

    public static void closeFolder(Folder folder) {
        MailTransportUtils.closeFolder(folder, false);
    }

    public static void closeFolder(Folder folder, boolean expunge) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(expunge);
            }
            catch (MessagingException ex) {
                logger.debug((Object)"Could not close JavaMail Folder", (Throwable)ex);
            }
            catch (NullPointerException ex) {
                logger.debug((Object)"Could not close JavaMail Folder", (Throwable)ex);
            }
        }
    }

    public static String toPasswordProtectedString(URLName name) {
        String protocol = name.getProtocol();
        String username = name.getUsername();
        String password = name.getPassword();
        String host = name.getHost();
        int port = name.getPort();
        String file = name.getFile();
        String ref = name.getRef();
        StringBuffer tempURL = new StringBuffer();
        if (protocol != null) {
            tempURL.append(protocol).append(':');
        }
        if (StringUtils.hasLength((String)username) || StringUtils.hasLength((String)host)) {
            tempURL.append("//");
            if (StringUtils.hasLength((String)username)) {
                tempURL.append(username);
                if (StringUtils.hasLength((String)password)) {
                    tempURL.append(":*****");
                }
                tempURL.append("@");
            }
            if (StringUtils.hasLength((String)host)) {
                tempURL.append(host);
            }
            if (port != -1) {
                tempURL.append(':').append(Integer.toString(port));
            }
            if (StringUtils.hasLength((String)file)) {
                tempURL.append('/');
            }
        }
        if (StringUtils.hasLength((String)file)) {
            tempURL.append(file);
        }
        if (StringUtils.hasLength((String)ref)) {
            tempURL.append('#').append(ref);
        }
        return tempURL.toString();
    }
}

