/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.concurrent.Executor;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapter
extends MessageProducerSupport {
    private final IdleTask idleTask = new IdleTask();
    private volatile boolean shouldReconnectAutomatically = true;
    private volatile Executor taskExecutor;
    private final ImapMailReceiver mailReceiver;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected void handleMailMessagingException(MessagingException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
        }
    }

    protected void doStart() {
        if (this.taskExecutor == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No TaskExecutor has been provided, will use a [" + SimpleAsyncTaskExecutor.class + "] as the default."));
            }
            this.taskExecutor = new SimpleAsyncTaskExecutor();
        }
        this.taskExecutor.execute(this.idleTask);
    }

    protected void doStop() {
        this.idleTask.interrupt();
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    private class IdleTask
    implements Runnable {
        private volatile Thread thread;

        private IdleTask() {
        }

        public synchronized void interrupt() {
            if (this.thread != null) {
                this.thread.interrupt();
            } else if (ImapIdleChannelAdapter.this.logger.isInfoEnabled()) {
                ImapIdleChannelAdapter.this.logger.info((Object)"monitor is not running, cannot interrupt");
            }
        }

        public void run() {
            this.thread = Thread.currentThread();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                    }
                    ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                    Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                    if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                        ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                    }
                    for (Message mailMessage : mailMessages) {
                        MimeMessage copied = new MimeMessage((MimeMessage)mailMessage);
                        ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                    }
                }
                catch (MessagingException e) {
                    if (e instanceof FolderClosedException && ImapIdleChannelAdapter.this.shouldReconnectAutomatically) continue;
                    ImapIdleChannelAdapter.this.handleMailMessagingException(e);
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

