/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ImapIdleChannelAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.mail";

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.mail.ImapIdleChannelAdapter";
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String channel = element.getAttribute("channel");
        Assert.hasText((String)channel, (String)"the 'channel' attribute is required");
        builder.addConstructorArgValue((Object)this.parseImapMailReceiver(element, parserContext));
        builder.addPropertyReference("outputChannel", channel);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"error-channel", (String)"errorChannel");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"task-executor");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
    }

    private BeanDefinition parseImapMailReceiver(Element element, ParserContext parserContext) {
        String session;
        BeanDefinitionBuilder receiverBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.mail.ImapMailReceiver");
        Object source = parserContext.extractSource((Object)element);
        String uri = element.getAttribute("store-uri");
        if (StringUtils.hasText((String)uri)) {
            receiverBuilder.addConstructorArgValue((Object)uri);
        }
        if (StringUtils.hasText((String)(session = element.getAttribute("session")))) {
            if (element.hasAttribute("java-mail-properties") || element.hasAttribute("authenticator")) {
                parserContext.getReaderContext().error("Neither 'java-mail-properties' nor 'authenticator' references are allowed when a 'session' reference has been provided.", source);
            }
            receiverBuilder.addPropertyReference("session", session);
        } else {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"java-mail-properties");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"authenticator", (String)"javaMailAuthenticator");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)receiverBuilder, (Element)element, (String)"max-fetch-size");
        receiverBuilder.addPropertyValue("shouldDeleteMessages", (Object)element.getAttribute("should-delete-messages"));
        String markAsRead = element.getAttribute("should-mark-messages-as-read");
        if (StringUtils.hasText((String)markAsRead)) {
            receiverBuilder.addPropertyValue("shouldMarkMessagesAsRead", (Object)markAsRead);
        }
        return receiverBuilder.getBeanDefinition();
    }
}

