/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.internet.MimeMessage;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.MessagingException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mapping.MessageMappingException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSendingMessageHandler
extends AbstractMessageHandler {
    private final JavaMailSender mailSender;

    public MailSendingMessageHandler(JavaMailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"'mailSender' must not be null");
        this.mailSender = mailSender;
    }

    protected final void handleMessageInternal(Message<?> message) {
        MailMessage mailMessage = this.convertMessageToMailMessage(message);
        if (mailMessage instanceof SimpleMailMessage) {
            this.mailSender.send((SimpleMailMessage)mailMessage);
        } else if (mailMessage instanceof MimeMailMessage) {
            this.mailSender.send(((MimeMailMessage)mailMessage).getMimeMessage());
        } else {
            throw new IllegalArgumentException("Unsupported MailMessage type [" + mailMessage.getClass().getName() + "].");
        }
    }

    private MailMessage convertMessageToMailMessage(Message<?> message) {
        MimeMailMessage mailMessage = null;
        Object payload = message.getPayload();
        if (payload instanceof MimeMessage) {
            mailMessage = new MimeMailMessage((MimeMessage)payload);
        } else if (payload instanceof MailMessage) {
            mailMessage = (MailMessage)payload;
        } else if (payload instanceof byte[]) {
            mailMessage = this.createMailMessageFromByteArrayMessage(message);
        } else if (payload instanceof String) {
            String contentType = (String)message.getHeaders().get((Object)"mail_contentType");
            if (StringUtils.hasText((String)contentType)) {
                mailMessage = this.createMailMessageWithContentType(message, contentType);
            } else {
                mailMessage = new SimpleMailMessage();
                mailMessage.setText((String)payload);
            }
        } else {
            throw new MessageHandlingException(message, "Unable to create MailMessage from payload type [" + message.getPayload().getClass().getName() + "], expected MimeMessage, MailMessage, byte array or String.");
        }
        this.applyHeadersToMailMessage((MailMessage)mailMessage, message.getHeaders());
        return mailMessage;
    }

    private MailMessage createMailMessageWithContentType(Message<String> message, String contentType) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            mimeMessage.setContent(message.getPayload(), contentType);
            return new MimeMailMessage(mimeMessage);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to creaet MimeMessage with contentType: " + contentType, (Throwable)e);
        }
    }

    private MailMessage createMailMessageFromByteArrayMessage(Message<byte[]> message) {
        String attachmentFileName = (String)message.getHeaders().get((Object)"mail_attachmentFilename", String.class);
        if (attachmentFileName == null) {
            throw new MessageMappingException(message, "Header 'mail_attachmentFilename' is required when mapping a Message with a byte array payload to a MailMessage.");
        }
        Integer multipartMode = (Integer)message.getHeaders().get((Object)"mail_multipartMode", Integer.class);
        if (multipartMode == null) {
            multipartMode = 1;
        }
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, multipartMode.intValue());
            helper.addAttachment(attachmentFileName, (InputStreamSource)new ByteArrayResource((byte[])message.getPayload()));
            return new MimeMailMessage(helper);
        }
        catch (javax.mail.MessagingException e) {
            throw new MessageMappingException(message, "failed to create MimeMessage", (Throwable)e);
        }
    }

    private void applyHeadersToMailMessage(MailMessage mailMessage, MessageHeaders headers) {
        String replyTo;
        String from;
        String[] bcc;
        String[] cc;
        String[] to;
        String subject = (String)headers.get((Object)"mail_subject", String.class);
        if (subject != null) {
            mailMessage.setSubject(subject);
        }
        if ((to = this.retrieveHeaderValueAsStringArray(headers, "mail_to")) != null) {
            mailMessage.setTo(to);
        }
        if (mailMessage instanceof SimpleMailMessage) {
            Assert.state((!ObjectUtils.isEmpty((Object[])((SimpleMailMessage)mailMessage).getTo()) ? 1 : 0) != 0, (String)"No recipient has been provided on the MailMessage or the 'MailHeaders.TO' header.");
        }
        if ((cc = this.retrieveHeaderValueAsStringArray(headers, "mail_cc")) != null) {
            mailMessage.setCc(cc);
        }
        if ((bcc = this.retrieveHeaderValueAsStringArray(headers, "mail_bcc")) != null) {
            mailMessage.setBcc(bcc);
        }
        if ((from = (String)headers.get((Object)"mail_from", String.class)) != null) {
            mailMessage.setFrom(from);
        }
        if ((replyTo = (String)headers.get((Object)"mail_replyTo", String.class)) != null) {
            mailMessage.setReplyTo(replyTo);
        }
    }

    private String[] retrieveHeaderValueAsStringArray(MessageHeaders headers, String key) {
        Object value = headers.get((Object)key);
        String[] returnedHeaders = null;
        if (value != null) {
            if (value instanceof String[]) {
                returnedHeaders = (String[])value;
            } else if (value instanceof String) {
                returnedHeaders = StringUtils.commaDelimitedListToStringArray((String)((String)value));
            }
        }
        if (returnedHeaders == null || ObjectUtils.isEmpty(returnedHeaders)) {
            returnedHeaders = null;
        }
        return returnedHeaders;
    }
}

