/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractMailReceiver
extends IntegrationObjectSupport
implements MailReceiver,
DisposableBean {
    public static final String DEFAULT_SI_USER_FLAG = "spring-integration-mail-adapter";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final URLName url;
    private final Object folderMonitor = new Object();
    private volatile String protocol;
    private volatile int maxFetchSize = -1;
    private volatile Session session;
    private volatile Store store;
    private volatile Folder folder;
    private volatile boolean shouldDeleteMessages;
    protected volatile int folderOpenMode = 1;
    private volatile Properties javaMailProperties = new Properties();
    private volatile Authenticator javaMailAuthenticator;
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression selectorExpression;
    private volatile HeaderMapper<MimeMessage> headerMapper;
    protected volatile boolean initialized;
    private volatile String userFlag = "spring-integration-mail-adapter";
    private volatile boolean embeddedPartsAsBytes = true;

    public AbstractMailReceiver() {
        this.url = null;
    }

    public AbstractMailReceiver(URLName urlName) {
        Assert.notNull((Object)urlName, (String)"urlName must not be null");
        this.url = urlName;
    }

    public AbstractMailReceiver(String url) {
        this.url = url != null ? new URLName(url) : null;
    }

    public void setSelectorExpression(Expression selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void setProtocol(String protocol) {
        if (this.url != null) {
            Assert.isTrue((boolean)this.url.getProtocol().equals(protocol), (String)"The 'protocol' does not match that provided by the Store URI.");
        }
        this.protocol = protocol;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    protected Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.javaMailAuthenticator = javaMailAuthenticator;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void setShouldDeleteMessages(boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    protected boolean shouldDeleteMessages() {
        return this.shouldDeleteMessages;
    }

    protected String getUserFlag() {
        return this.userFlag;
    }

    public void setUserFlag(String userFlag) {
        this.userFlag = userFlag;
    }

    public void setHeaderMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setEmbeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.embeddedPartsAsBytes = embeddedPartsAsBytes;
    }

    protected Folder getFolder() {
        return this.folder;
    }

    protected abstract Message[] searchForNewMessages() throws javax.mail.MessagingException;

    private void openSession() throws javax.mail.MessagingException {
        if (this.session == null) {
            this.session = this.javaMailAuthenticator != null ? Session.getInstance((Properties)this.javaMailProperties, (Authenticator)this.javaMailAuthenticator) : Session.getInstance((Properties)this.javaMailProperties);
        }
    }

    private void connectStoreIfNecessary() throws javax.mail.MessagingException {
        if (this.store == null) {
            this.store = this.url != null ? this.session.getStore(this.url) : (this.protocol != null ? this.session.getStore(this.protocol) : this.session.getStore());
        }
        if (!this.store.isConnected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("connecting to store [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
            }
            this.store.connect();
        }
    }

    protected void openFolder() throws javax.mail.MessagingException {
        if (this.folder == null) {
            this.openSession();
            this.connectStoreIfNecessary();
            this.folder = this.obtainFolderInstance();
        } else {
            this.connectStoreIfNecessary();
        }
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("no such folder [" + this.url.getFile() + "]");
        }
        if (this.folder.isOpen()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("opening folder [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
        }
        this.folder.open(this.folderOpenMode);
    }

    private Folder obtainFolderInstance() throws javax.mail.MessagingException {
        return this.store.getFolder(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] receive() throws javax.mail.MessagingException {
        Object object = this.folderMonitor;
        synchronized (object) {
            try {
                this.openFolder();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("attempting to receive mail from folder [" + this.getFolder().getFullName() + "]"));
                }
                Message[] messages = this.searchForNewMessages();
                if (this.maxFetchSize > 0 && messages.length > this.maxFetchSize) {
                    Message[] reducedMessages = new Message[this.maxFetchSize];
                    System.arraycopy(messages, 0, reducedMessages, 0, this.maxFetchSize);
                    messages = reducedMessages;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("found " + messages.length + " new messages"));
                }
                if (messages.length > 0) {
                    this.fetchMessages(messages);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received " + messages.length + " messages"));
                }
                Object[] filteredMessages = this.filterMessagesThruSelector(messages);
                this.postProcessFilteredMessages((Message[])filteredMessages);
                if (this.headerMapper != null) {
                    org.springframework.messaging.Message[] converted = new org.springframework.messaging.Message[filteredMessages.length];
                    int n = 0;
                    Object[] objectArray = filteredMessages;
                    int n2 = objectArray.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            objectArray = converted;
                            return objectArray;
                        }
                        Object message = objectArray[n3];
                        Map headers = this.headerMapper.toHeaders(message);
                        converted[n++] = this.getMessageBuilderFactory().withPayload(this.extractContent((MimeMessage)message, headers)).copyHeaders(headers).build();
                        ++n3;
                    }
                }
                Object[] objectArray = filteredMessages;
                return objectArray;
            }
            finally {
                MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
            }
        }
    }

    private Object extractContent(MimeMessage message, Map<String, Object> headers) {
        try {
            Object content = message.getContent();
            if (content instanceof String) {
                String mailContentType = (String)headers.get("mail_contentType");
                if (mailContentType != null && mailContentType.toLowerCase().startsWith("text")) {
                    headers.put("contentType", mailContentType);
                } else {
                    headers.put("contentType", "text/plain");
                }
            } else if (content instanceof InputStream) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)((InputStream)content), (OutputStream)baos);
                content = this.byteArrayToContent(headers, baos);
            } else if (content instanceof Multipart && this.embeddedPartsAsBytes) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((Multipart)content).writeTo((OutputStream)baos);
                content = this.byteArrayToContent(headers, baos);
            } else if (content instanceof Part && this.embeddedPartsAsBytes) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((Part)content).writeTo((OutputStream)baos);
                content = this.byteArrayToContent(headers, baos);
            }
            return content;
        }
        catch (Exception e) {
            throw new MessagingException("Failed to extract content from " + message, (Throwable)e);
        }
    }

    private Object byteArrayToContent(Map<String, Object> headers, ByteArrayOutputStream baos) {
        headers.put("contentType", "application/octet-stream");
        return baos.toByteArray();
    }

    private void postProcessFilteredMessages(Message[] filteredMessages) throws javax.mail.MessagingException {
        this.setMessageFlags(filteredMessages);
        if (this.shouldDeleteMessages()) {
            this.deleteMessages(filteredMessages);
        }
        if (this.headerMapper == null) {
            for (int i = 0; i < filteredMessages.length; ++i) {
                IntegrationMimeMessage mimeMessage = new IntegrationMimeMessage((MimeMessage)filteredMessages[i]);
                filteredMessages[i] = mimeMessage;
            }
        }
    }

    private void setMessageFlags(Message[] filteredMessages) throws javax.mail.MessagingException {
        boolean recentFlagSupported = false;
        Flags flags = this.getFolder().getPermanentFlags();
        if (flags != null) {
            recentFlagSupported = flags.contains(Flags.Flag.RECENT);
        }
        for (Message message : filteredMessages) {
            if (!recentFlagSupported) {
                if (flags != null && flags.contains(Flags.Flag.USER)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("USER flags are supported by this mail server. Flagging message with '" + this.userFlag + "' user flag"));
                    }
                    Flags siFlags = new Flags();
                    siFlags.add(this.userFlag);
                    message.setFlags(siFlags, true);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"USER flags are not supported by this mail server. Flagging message with system flag");
                    }
                    message.setFlag(Flags.Flag.FLAGGED, true);
                }
            }
            this.setAdditionalFlags(message);
        }
    }

    private MimeMessage[] filterMessagesThruSelector(Message[] messages) throws javax.mail.MessagingException {
        LinkedList<MimeMessage> filteredMessages = new LinkedList<MimeMessage>();
        for (int i = 0; i < messages.length; ++i) {
            MimeMessage message = (MimeMessage)messages[i];
            if (this.selectorExpression != null) {
                if (((Boolean)this.selectorExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Boolean.class)).booleanValue()) {
                    filteredMessages.add(message);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Fetched email with subject '" + message.getSubject() + "' will be discarded by the matching filter" + " and will not be flagged as SEEN."));
                continue;
            }
            filteredMessages.add(message);
        }
        return filteredMessages.toArray(new MimeMessage[filteredMessages.size()]);
    }

    protected void fetchMessages(Message[] messages) throws javax.mail.MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        this.folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Message[] messages) throws javax.mail.MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
    }

    protected void setAdditionalFlags(Message message) throws javax.mail.MessagingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.folderMonitor;
        synchronized (object) {
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
            MailTransportUtils.closeService((Service)this.store);
            this.folder = null;
            this.store = null;
            this.initialized = false;
        }
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.folderOpenMode = 2;
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        this.initialized = true;
    }

    public String toString() {
        return this.url.toString();
    }

    Store getStore() {
        return this.store;
    }

    private final class IntegrationMimeMessage
    extends MimeMessage {
        private final MimeMessage source;

        private IntegrationMimeMessage(MimeMessage source) throws javax.mail.MessagingException {
            super(source);
            this.source = source;
        }

        public Folder getFolder() {
            try {
                return AbstractMailReceiver.this.obtainFolderInstance();
            }
            catch (javax.mail.MessagingException e) {
                throw new MessagingException("Unable to obtain the mail folder", (Throwable)e);
            }
        }

        public Date getReceivedDate() throws javax.mail.MessagingException {
            return this.source.getReceivedDate();
        }

        public int getLineCount() throws javax.mail.MessagingException {
            return this.source.getLineCount();
        }
    }
}

