/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mail.MailSendingMessageHandler;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MailOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MailSendingMessageHandler.class);
        String mailSenderRef = element.getAttribute("mail-sender");
        String host = element.getAttribute("host");
        String port = element.getAttribute("port");
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        if (StringUtils.hasText((String)mailSenderRef)) {
            Assert.isTrue((!StringUtils.hasText((String)host) && !StringUtils.hasText((String)username) && !StringUtils.hasText((String)password) ? 1 : 0) != 0, (String)"The 'host', 'username', and 'password' properties should not be provided when using a 'mail-sender' reference.");
            builder.addConstructorArgReference(mailSenderRef);
        } else {
            Assert.hasText((String)host, (String)"Either a 'mail-sender' reference or 'host' property is required.");
            BeanDefinitionBuilder mailSenderBuilder = BeanDefinitionBuilder.genericBeanDefinition(JavaMailSenderImpl.class);
            mailSenderBuilder.addPropertyValue("host", (Object)host);
            if (StringUtils.hasText((String)username)) {
                mailSenderBuilder.addPropertyValue("username", (Object)username);
            }
            if (StringUtils.hasText((String)password)) {
                mailSenderBuilder.addPropertyValue("password", (Object)password);
            }
            if (StringUtils.hasText((String)port)) {
                mailSenderBuilder.addPropertyValue("port", (Object)port);
            }
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)mailSenderBuilder, (Element)element, (String)"java-mail-properties", (String)"javaMailProperties");
            String mailSenderBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mailSenderBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            builder.addConstructorArgReference(mailSenderBeanName);
        }
        return builder.getBeanDefinition();
    }
}

