/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.inbound;

import java.util.ArrayList;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.Message;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.converter.MessageConverter;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisInboundChannelAdapter
extends MessageProducerSupport {
    private final RedisMessageListenerContainer container = new RedisMessageListenerContainer();
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile String[] topics;

    public RedisInboundChannelAdapter(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.container.setConnectionFactory(connectionFactory);
    }

    public void setTopics(String ... topics) {
        this.topics = topics;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public String getComponentType() {
        return "redis:inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        Assert.notEmpty((Object[])this.topics, (String)"at least one topis is required for subscription");
        MessageListenerDelegate delegate = new MessageListenerDelegate();
        MessageListenerAdapter adapter = new MessageListenerAdapter((Object)delegate);
        adapter.setSerializer((RedisSerializer)new StringRedisSerializer());
        ArrayList<ChannelTopic> topicList = new ArrayList<ChannelTopic>();
        for (String topic : this.topics) {
            topicList.add(new ChannelTopic(topic));
        }
        adapter.afterPropertiesSet();
        this.container.addMessageListener((MessageListener)adapter, topicList);
        this.container.afterPropertiesSet();
    }

    protected void doStart() {
        super.doStart();
        this.container.start();
    }

    protected void doStop() {
        super.doStop();
        this.container.stop();
    }

    private Message<?> convertMessage(String s) {
        return this.messageConverter.toMessage((Object)s);
    }

    private class MessageListenerDelegate {
        private MessageListenerDelegate() {
        }

        public void handleMessage(String s) {
            RedisInboundChannelAdapter.this.sendMessage(RedisInboundChannelAdapter.this.convertMessage(s));
        }
    }
}

