/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.inbound;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.collections.RedisCollectionFactoryBean;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisStoreMessageSource
extends IntegrationObjectSupport
implements MessageSource<RedisStore> {
    private final ThreadLocal<RedisStore> resourceHolder = new ThreadLocal();
    private volatile StandardEvaluationContext evaluationContext;
    private volatile Expression keyExpression;
    private volatile RedisCollectionFactoryBean.CollectionType collectionType = RedisCollectionFactoryBean.CollectionType.LIST;
    private final RedisTemplate<String, ?> redisTemplate;

    public RedisStoreMessageSource(RedisTemplate<String, ?> redisTemplate, Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        this.redisTemplate = redisTemplate;
        this.keyExpression = keyExpression;
    }

    public RedisStoreMessageSource(RedisConnectionFactory connectionFactory, Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"'keyExpression' must not be null");
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        StringRedisTemplate redisTemplate = new StringRedisTemplate();
        redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate = redisTemplate;
        this.keyExpression = keyExpression;
    }

    public void setCollectionType(RedisCollectionFactoryBean.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public Message<RedisStore> receive() {
        String key = (String)this.keyExpression.getValue((EvaluationContext)this.evaluationContext, String.class);
        Assert.hasText((String)key, (String)"Failed to determine the key for the collection");
        RedisStore store = this.createStoreView(key);
        Object holder = TransactionSynchronizationManager.getResource((Object)((Object)this));
        if (holder != null) {
            Assert.isInstanceOf(IntegrationResourceHolder.class, (Object)holder);
            ((IntegrationResourceHolder)holder).addAttribute("store", (Object)store);
        }
        if (store instanceof Collection && ((Collection)store).size() < 1) {
            return null;
        }
        return MessageBuilder.withPayload((Object)store).build();
    }

    private RedisStore createStoreView(String key) {
        RedisCollectionFactoryBean fb = new RedisCollectionFactoryBean();
        fb.setKey(key);
        fb.setTemplate(this.redisTemplate);
        fb.setType(this.collectionType);
        fb.afterPropertiesSet();
        return fb.getObject();
    }

    protected void onInit() throws Exception {
        this.evaluationContext = this.getBeanFactory() != null ? ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory()) : ExpressionUtils.createStandardEvaluationContext();
    }

    public RedisStore getResource() {
        return this.resourceHolder.get();
    }

    public void afterCommit(Object object) {
        this.resourceHolder.remove();
    }

    public void afterRollback(Object object) {
        this.resourceHolder.remove();
    }
}

