/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.redis.outbound.RedisQueueOutboundGateway;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RedisQueueOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(RedisQueueOutboundGateway.class);
        builder.addConstructorArgValue((Object)element.getAttribute("queue"));
        String connectionFactory = element.getAttribute("connection-factory");
        if (!StringUtils.hasText((String)connectionFactory)) {
            connectionFactory = "redisConnectionFactory";
        }
        builder.addConstructorArgReference(connectionFactory);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel", (String)"outputChannel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"serializer");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"receiveTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        return builder;
    }
}

