/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scripting.jsr223;

import java.util.Date;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.scripting.ScriptExecutor;
import org.springframework.integration.scripting.ScriptingException;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractScriptExecutor
implements ScriptExecutor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    protected final String language;

    public AbstractScriptExecutor(String language) {
        Assert.hasText((String)language, (String)"language must not be empty");
        this.language = language;
        if (this.logger.isDebugEnabled()) {
            ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.language);
            if (scriptEngine == null) {
                this.logger.error((Object)AbstractScriptExecutor.invlalidLanguageMessage(this.language));
            } else {
                this.logger.debug((Object)("using script engine : " + scriptEngine.getFactory().getEngineName()));
            }
        }
    }

    @Override
    public Object executeScript(ScriptSource scriptSource) {
        return this.executeScript(scriptSource, null);
    }

    @Override
    public Object executeScript(ScriptSource scriptSource, Map<String, Object> variables) {
        Object result = null;
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.language);
        if (scriptEngine == null) {
            throw new ScriptingException(AbstractScriptExecutor.invlalidLanguageMessage(this.language));
        }
        try {
            if (variables != null) {
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    scriptEngine.put(entry.getKey(), entry.getValue());
                }
            }
            String script = scriptSource.getScriptAsString();
            Date start = new Date();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("executing script: " + script));
            }
            result = scriptEngine.eval(script);
            result = this.postProcess(result, scriptEngine, script);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("script executed in " + (new Date().getTime() - start.getTime()) + " ms"));
            }
        }
        catch (Exception e) {
            throw new ScriptingException(e.getMessage(), e);
        }
        return result;
    }

    protected abstract Object postProcess(Object var1, ScriptEngine var2, String var3);

    private static String invlalidLanguageMessage(String language) {
        return ScriptEngineManager.class.getName() + " is unable to create a script engine for language '" + language + "'.\n" + "This may be due to a missing language implementation or an invalid language name.";
    }
}

