/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpFileInfo
extends AbstractFileInfo<ChannelSftp.LsEntry> {
    private final ChannelSftp.LsEntry lsEntry;
    private final SftpATTRS attrs;

    public SftpFileInfo(ChannelSftp.LsEntry lsEntry) {
        Assert.notNull((Object)"LsEntry must not be null");
        this.lsEntry = lsEntry;
        this.attrs = lsEntry.getAttrs();
    }

    public boolean isDirectory() {
        return this.attrs.isDir();
    }

    public boolean isLink() {
        return this.attrs.isLink();
    }

    public long getSize() {
        return this.attrs.getSize();
    }

    public long getModified() {
        return this.attrs.getMTime() * 1000;
    }

    public String getFilename() {
        return this.lsEntry.getFilename();
    }

    public String getPermissions() {
        return this.attrs.getPermissionsString();
    }

    public ChannelSftp.LsEntry getFileInfo() {
        return this.lsEntry;
    }
}

