/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.springframework.messaging.Message;

public class PayloadAndHeaderMatcher<T>
extends BaseMatcher<Message<?>> {
    private final T payload;
    private final Map<String, Object> headers;
    private final String[] ignoreKeys;

    @Factory
    public static <P> PayloadAndHeaderMatcher<P> sameExceptIgnorableHeaders(Message<P> expected, String ... ignoreKeys) {
        return new PayloadAndHeaderMatcher<P>(expected, ignoreKeys);
    }

    private PayloadAndHeaderMatcher(Message<T> expected, String ... ignoreKeys) {
        this.ignoreKeys = ignoreKeys;
        this.payload = expected.getPayload();
        this.headers = this.extractHeadersToAssert(expected);
    }

    private Map<String, Object> extractHeadersToAssert(Message<?> operand) {
        HashMap<String, Object> headers = new HashMap<String, Object>((Map<String, Object>)operand.getHeaders());
        headers.remove("id");
        headers.remove("timestamp");
        if (this.ignoreKeys != null) {
            for (String key : this.ignoreKeys) {
                headers.remove(key);
            }
        }
        return headers;
    }

    public boolean matches(Object arg) {
        Message input = (Message)arg;
        Map<String, Object> inputHeaders = this.extractHeadersToAssert(input);
        return input.getPayload().equals(this.payload) && inputHeaders.equals(this.headers);
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers that match except ID and timestamp for payload: ").appendValue(this.payload).appendText(" and headers: ").appendValue(this.headers);
    }
}

