/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.springframework.integration.Message;
import org.springframework.integration.test.matcher.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadMatcher
extends TypeSafeMatcher<Message<?>> {
    private final Matcher<?> matcher;

    PayloadMatcher(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matchesSafely(Message<?> message) {
        return this.matcher.matches(message.getPayload());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with payload: ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <T> Matcher<Message<?>> hasPayload(T payload) {
        return new PayloadMatcher(IsEqual.equalTo(payload));
    }

    @Factory
    public static <T> Matcher<Message<?>> hasPayload(Matcher<T> payloadMatcher) {
        return new PayloadMatcher(payloadMatcher);
    }
}

