/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.context.NamedComponent;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ErrorHandler;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestUtils {
    public static Object getPropertyValue(Object root, String propertyPath) {
        Object value = null;
        DirectFieldAccessor accessor = new DirectFieldAccessor(root);
        String[] tokens = propertyPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            value = accessor.getPropertyValue(tokens[i]);
            if (value == null) {
                if (i == tokens.length - 1) {
                    return null;
                }
                throw new IllegalArgumentException("intermediate property '" + tokens[i] + "' is null");
            }
            accessor = new DirectFieldAccessor(value);
        }
        return value;
    }

    public static <T> T getPropertyValue(Object root, String propertyPath, Class<T> type) {
        Object value = TestUtils.getPropertyValue(root, propertyPath);
        org.springframework.util.Assert.isAssignable(type, value.getClass());
        return (T)value;
    }

    public static TestApplicationContext createTestApplicationContext() {
        TestApplicationContext context = new TestApplicationContext();
        MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler((ChannelResolver)new BeanFactoryChannelResolver((BeanFactory)context));
        ThreadPoolTaskScheduler scheduler = TestUtils.createTaskScheduler(10);
        scheduler.setErrorHandler((ErrorHandler)errorHandler);
        TestUtils.registerBean("taskScheduler", scheduler, (BeanFactory)context);
        return context;
    }

    public static ThreadPoolTaskScheduler createTaskScheduler(int poolSize) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(poolSize);
        scheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        scheduler.afterPropertiesSet();
        return scheduler;
    }

    private static void registerBean(String beanName, Object bean, BeanFactory beanFactory) {
        org.springframework.util.Assert.notNull((Object)beanName, (String)"bean name must not be null");
        ConfigurableListableBeanFactory configurableListableBeanFactory = null;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
        } else if (beanFactory instanceof GenericApplicationContext) {
            configurableListableBeanFactory = ((GenericApplicationContext)beanFactory).getBeanFactory();
        }
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(beanName);
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory(beanFactory);
        }
        if (bean instanceof InitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new FatalBeanException("failed to register bean with test context", (Throwable)e);
            }
        }
        configurableListableBeanFactory.registerSingleton(beanName, bean);
    }

    public static MessageHandler handlerExpecting(final Matcher<Message> messageMatcher) {
        return new MessageHandler(){

            public void handleMessage(Message<?> message) throws MessageRejectedException, MessageHandlingException, MessageDeliveryException {
                Assert.assertThat(message, (Matcher)CoreMatchers.is((Matcher)messageMatcher));
            }
        };
    }

    public static Properties locateComponentInHistory(MessageHistory history, String componentName, int startingIndex) {
        org.springframework.util.Assert.notNull((Object)history, (String)"'history' must not be null");
        org.springframework.util.Assert.isTrue((boolean)StringUtils.hasText((String)componentName), (String)"'componentName' must be provided");
        org.springframework.util.Assert.isTrue((startingIndex < history.size() ? 1 : 0) != 0, (String)"'startingIndex' can not be greater then size of history");
        Properties component = null;
        for (int i = startingIndex; i < history.size(); ++i) {
            Properties properties = history.get(i);
            if (!componentName.equals(properties.get("name"))) continue;
            component = properties;
            break;
        }
        return component;
    }

    public static String applySystemFileSeparator(String s) {
        return s.replaceAll("/", java.util.regex.Matcher.quoteReplacement(File.separator));
    }

    public static class TestApplicationContext
    extends GenericApplicationContext {
        private TestApplicationContext() {
        }

        public void registerChannel(String channelName, MessageChannel channel) {
            if (channel instanceof NamedComponent && ((NamedComponent)channel).getComponentName() != null) {
                if (channelName == null) {
                    channelName = ((NamedComponent)channel).getComponentName();
                } else {
                    org.springframework.util.Assert.isTrue((boolean)((NamedComponent)channel).getComponentName().equals(channelName), (String)"channel name has already been set with a conflicting value");
                }
            }
            TestUtils.registerBean(channelName, channel, (BeanFactory)this);
        }

        public void registerEndpoint(String endpointName, AbstractEndpoint endpoint) {
            TestUtils.registerBean(endpointName, endpoint, (BeanFactory)this);
        }
    }
}

