/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.springframework.util.Assert;

public final class SocketUtils {
    public static final int DEFAULT_PORT_RANGE_MIN = 10000;
    public static final int DEFAULT_PORT_RANGE_MAX = 60000;

    public static int findAvailableServerSocket(int seed) {
        List<Integer> openPorts = SocketUtils.findAvailableServerSockets(seed, 1);
        return openPorts.get(0);
    }

    public static List<Integer> findAvailableServerSockets(int seed, int numberOfRequestedPorts) {
        Assert.isTrue((seed >= 0 ? 1 : 0) != 0, (String)"'seed' must not be negative");
        Assert.isTrue((numberOfRequestedPorts > 0 ? 1 : 0) != 0, (String)"'numberOfRequestedPorts' must not be negative");
        ArrayList<Integer> openPorts = new ArrayList<Integer>(numberOfRequestedPorts);
        for (int i = seed; i < seed + 200; ++i) {
            try {
                ServerSocket sock = ServerSocketFactory.getDefault().createServerSocket(i);
                sock.close();
                openPorts.add(i);
                if (openPorts.size() != numberOfRequestedPorts) continue;
                return openPorts;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalStateException(String.format("Cannot find a free server socket (%s requested)", numberOfRequestedPorts));
    }

    public static int findAvailableServerSocket() {
        int seed = SocketUtils.getRandomSeedPort();
        return SocketUtils.findAvailableServerSocket(seed);
    }

    public static int findAvailableUdpSocket(int seed) {
        List<Integer> openPorts = SocketUtils.findAvailableUdpSockets(seed, 1);
        return openPorts.get(0);
    }

    public static List<Integer> findAvailableUdpSockets(int seed, int numberOfRequestedPorts) {
        Assert.isTrue((seed >= 0 ? 1 : 0) != 0, (String)"'seed' must not be negative");
        Assert.isTrue((numberOfRequestedPorts > 0 ? 1 : 0) != 0, (String)"'numberOfRequestedPorts' must not be negative");
        ArrayList<Integer> openPorts = new ArrayList<Integer>(numberOfRequestedPorts);
        for (int i = seed; i < seed + 200; ++i) {
            try {
                DatagramSocket sock = new DatagramSocket(i);
                sock.close();
                Thread.sleep(100L);
                openPorts.add(i);
                if (openPorts.size() != numberOfRequestedPorts) continue;
                return openPorts;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalStateException(String.format("Cannot find a free server socket (%s requested)", numberOfRequestedPorts));
    }

    public static int findAvailableUdpSocket() {
        int seed = SocketUtils.getRandomSeedPort();
        return SocketUtils.findAvailableUdpSocket(seed);
    }

    public static int getRandomSeedPort() {
        Random random = new Random();
        int randomNumber = random.nextInt(50001) + 10000;
        return randomNumber;
    }
}

