/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class TwitterInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    private static final String BASE_PACKAGE = "org.springframework.integration.twitter";

    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        String className = TwitterInboundChannelAdapterParser.determineClassName(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)className);
        String templateBeanName = element.getAttribute("twitter-template");
        if (StringUtils.hasText((String)templateBeanName)) {
            builder.addConstructorArgReference(templateBeanName);
        } else {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.twitter.core.Twitter4jTemplate");
            builder.addConstructorArgValue((Object)templateBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"query");
        return builder.getBeanDefinition();
    }

    private static String determineClassName(Element element, ParserContext parserContext) {
        String className = null;
        String elementName = element.getLocalName().trim();
        if ("inbound-channel-adapter".equals(elementName)) {
            className = "org.springframework.integration.twitter.inbound.TimelineReceivingMessageSource";
        } else if ("dm-inbound-channel-adapter".equals(elementName)) {
            className = "org.springframework.integration.twitter.inbound.DirectMessageReceivingMessageSource";
        } else if ("mentions-inbound-channel-adapter".equals(elementName)) {
            className = "org.springframework.integration.twitter.inbound.MentionsReceivingMessageSource";
        } else if ("search-inbound-channel-adapter".equals(elementName)) {
            className = "org.springframework.integration.twitter.inbound.SearchReceivingMessageSource";
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return className;
    }
}

