/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.inbound;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.store.MetadataStore;
import org.springframework.integration.store.SimpleMetadataStore;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.twitter.core.Tweet;
import org.springframework.integration.twitter.core.TwitterOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTwitterMessageSource<T>
extends IntegrationObjectSupport
implements MessageSource {
    private volatile long lastPollForTweet;
    private volatile MetadataStore metadataStore;
    private volatile String metadataKey;
    private final Queue<Tweet> tweets = new LinkedBlockingQueue<Tweet>();
    private volatile int prefetchThreshold = 0;
    private volatile long lastEnqueuedId = -1L;
    private volatile long lastProcessedId = -1L;
    private final TwitterOperations twitterOperations;
    private final TweetComparator tweetComparator = new TweetComparator();
    private final Object lastEnqueuedIdMonitor = new Object();

    public AbstractTwitterMessageSource(TwitterOperations twitterOperations) {
        Assert.notNull((Object)twitterOperations, (String)"twitterOperations must not be null");
        this.twitterOperations = twitterOperations;
    }

    protected TwitterOperations getTwitterOperations() {
        return this.twitterOperations;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        StringBuilder metadataKeyBuilder = new StringBuilder();
        if (StringUtils.hasText((String)this.getComponentType())) {
            metadataKeyBuilder.append(this.getComponentType() + ".");
        }
        if (StringUtils.hasText((String)this.getComponentName())) {
            metadataKeyBuilder.append(this.getComponentName() + ".");
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " has no name. MetadataStore key might not be unique."));
        }
        String profileId = this.twitterOperations.getProfileId();
        if (profileId != null) {
            metadataKeyBuilder.append(profileId);
        }
        this.metadataKey = metadataKeyBuilder.toString();
        String lastId = this.metadataStore.get(this.metadataKey);
        if (StringUtils.hasText((String)lastId)) {
            this.lastEnqueuedId = this.lastProcessedId = Long.parseLong(lastId);
        }
    }

    public Message<?> receive() {
        Tweet tweet = this.tweets.poll();
        if (tweet == null) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.lastPollForTweet;
            if (elapsedTime < 15000L) {
                return null;
            }
            this.refreshTweetQueueIfNecessary();
            tweet = this.tweets.poll();
            this.lastPollForTweet = currentTime;
        }
        if (tweet != null) {
            this.lastProcessedId = tweet.getId();
            this.metadataStore.put(this.metadataKey, String.valueOf(this.lastProcessedId));
            return MessageBuilder.withPayload((Object)tweet).build();
        }
        return null;
    }

    private void enqueueAll(List<Tweet> tweets) {
        Collections.sort(tweets, this.tweetComparator);
        for (Tweet tweet : tweets) {
            this.enqueue(tweet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Tweet tweet) {
        Object object = this.lastEnqueuedIdMonitor;
        synchronized (object) {
            long id = tweet.getId();
            if (id > this.lastEnqueuedId) {
                this.tweets.add(tweet);
                this.lastEnqueuedId = id;
            }
        }
    }

    private void refreshTweetQueueIfNecessary() {
        try {
            List<Tweet> tweets;
            if (this.tweets.size() <= this.prefetchThreshold && !CollectionUtils.isEmpty(tweets = this.pollForTweets(this.lastEnqueuedId))) {
                this.enqueueAll(tweets);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("failed while polling Twitter", (Throwable)e);
        }
    }

    protected abstract List<Tweet> pollForTweets(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TweetComparator
    implements Comparator<Tweet> {
        private TweetComparator() {
        }

        @Override
        public int compare(Tweet tweet1, Tweet tweet2) {
            return tweet1.getCreatedAt().compareTo(tweet2.getCreatedAt());
        }
    }
}

