/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.inbound;

import java.util.List;
import org.springframework.integration.twitter.core.SearchResults;
import org.springframework.integration.twitter.core.Tweet;
import org.springframework.integration.twitter.core.TwitterOperations;
import org.springframework.integration.twitter.inbound.AbstractTwitterMessageSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchReceivingMessageSource
extends AbstractTwitterMessageSource<Tweet> {
    private volatile String query;

    public SearchReceivingMessageSource(TwitterOperations twitter) {
        super(twitter);
    }

    public void setQuery(String query) {
        Assert.hasText((String)query, (String)"'query' must not be null");
        this.query = query;
    }

    public String getComponentType() {
        return "twitter:search-inbound-channel-adapter";
    }

    @Override
    protected List<Tweet> pollForTweets(long sinceId) {
        SearchResults results = sinceId > 0L ? this.getTwitterOperations().search(this.query, sinceId) : this.getTwitterOperations().search(this.query);
        return results != null ? results.getTweets() : null;
    }
}

