/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.websocket.ServerWebSocketContainer;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ServerWebSocketContainerParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return ServerWebSocketContainer.class;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String[] ids;
        builder.addConstructorArgValue((Object)element.getAttribute("path"));
        String handshakeInterceptors = element.getAttribute("handshake-interceptors");
        ManagedList handshakeInterceptorList = new ManagedList();
        for (String id : ids = StringUtils.commaDelimitedListToStringArray((String)handshakeInterceptors)) {
            handshakeInterceptorList.add(new RuntimeBeanReference(id));
        }
        builder.addPropertyValue("interceptors", (Object)handshakeInterceptorList);
        String decoratorFactories = element.getAttribute("decorator-factories");
        ManagedList decoratorFactoryList = new ManagedList();
        for (String id : ids = StringUtils.commaDelimitedListToStringArray((String)decoratorFactories)) {
            decoratorFactoryList.add(new RuntimeBeanReference(id));
        }
        builder.addPropertyValue("decoratorFactories", (Object)decoratorFactoryList);
        Element sockjs = DomUtils.getChildElementByTagName((Element)element, (String)"sockjs");
        if (sockjs != null) {
            BeanDefinitionBuilder sockjsBuilder = BeanDefinitionBuilder.genericBeanDefinition(ServerWebSocketContainer.SockJsServiceOptions.class);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"client-library-url");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"websocket-enabled", (String)"webSocketEnabled");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"stream-bytes-limit");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"session-cookie-needed");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"heartbeat-time");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"disconnect-delay");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"message-cache-size", (String)"httpMessageCacheSize");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"scheduler", (String)"taskScheduler");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)sockjsBuilder, (Element)sockjs, (String)"message-codec");
            String transportHandlers = sockjs.getAttribute("transport-handlers");
            if (StringUtils.hasText((String)transportHandlers)) {
                ManagedList transportHandlerList = new ManagedList();
                for (String id : ids = StringUtils.commaDelimitedListToStringArray((String)transportHandlers)) {
                    transportHandlerList.add(new RuntimeBeanReference(id));
                }
                sockjsBuilder.addPropertyValue("transportHandlers", (Object)transportHandlerList);
            }
            builder.addPropertyValue("sockJsServiceOptions", (Object)sockjsBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"handshake-handler");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-buffer-size-limit");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-time-limit");
    }
}

