/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.MessagingException;
import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.integration.ws.MarshallingWebServiceOutboundGateway;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.SourceExtractor;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    private final SourceExtractor sourceExtractor;

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider) {
        this(destinationProvider, null, null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, SourceExtractor sourceExtractor) {
        this(destinationProvider, sourceExtractor, null);
    }

    public SimpleWebServiceOutboundGateway(DestinationProvider destinationProvider, SourceExtractor sourceExtractor, WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new DefaultSourceExtractor();
    }

    protected Object doHandle(Object requestPayload, WebServiceMessageCallback requestCallback) {
        if (requestPayload instanceof Source) {
            return this.getWebServiceTemplate().sendSourceAndReceive((Source)requestPayload, requestCallback, this.sourceExtractor);
        }
        if (requestPayload instanceof String) {
            StringResult result = new StringResult();
            this.getWebServiceTemplate().sendSourceAndReceiveToResult((Source)new StringSource((String)requestPayload), requestCallback, (Result)result);
            return result.toString();
        }
        if (requestPayload instanceof Document) {
            DOMResult result = new DOMResult();
            this.getWebServiceTemplate().sendSourceAndReceiveToResult((Source)new DOMSource((Document)requestPayload), requestCallback, (Result)result);
            return result.getNode();
        }
        throw new MessagingException("Unsupported payload type '" + requestPayload.getClass() + "'. " + ((Object)((Object)this)).getClass().getName() + " only supports 'java.lang.String', '" + Source.class.getName() + "', and '" + Document.class.getName() + "'. Consider either using the '" + MarshallingWebServiceOutboundGateway.class.getName() + "' or a Message Transformer.");
    }

    private static class DefaultSourceExtractor
    extends TransformerObjectSupport
    implements SourceExtractor {
        private DefaultSourceExtractor() {
        }

        public Object extractData(Source source) throws IOException, TransformerException {
            if (source instanceof DOMSource) {
                return source;
            }
            DOMResult result = new DOMResult();
            this.transform(source, result);
            return new DOMSource(result.getNode());
        }
    }
}

