/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.Message;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.ws.AbstractWebServiceInboundGateway;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.xml.transform.StringSource;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;

public class SimpleWebServiceInboundGateway
extends AbstractWebServiceInboundGateway {
    private final TransformerSupportDelegate transformerSupportDelegate = new TransformerSupportDelegate();
    private volatile boolean extractPayload = true;

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    @Override
    protected void doInvoke(MessageContext messageContext) throws Exception {
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        MessageBuilder builder = MessageBuilder.withPayload((Object)(this.extractPayload ? request.getPayloadSource() : request));
        this.fromSoapHeaders(messageContext, builder);
        Message replyMessage = this.sendAndReceiveMessage(builder.build());
        if (replyMessage != null) {
            Object replyPayload = replyMessage.getPayload();
            Source responseSource = null;
            if (replyPayload instanceof Source) {
                responseSource = (Source)replyPayload;
            } else if (replyPayload instanceof Document) {
                responseSource = new DOMSource((Document)replyPayload);
            } else if (replyPayload instanceof String) {
                responseSource = new StringSource((String)replyPayload);
            } else {
                throw new IllegalArgumentException("The reply Message payload must be a [" + Source.class.getName() + "], [" + Document.class.getName() + "], or [java.lang.String]. The actual type was [" + replyPayload.getClass().getName() + "]");
            }
            WebServiceMessage response = messageContext.getResponse();
            this.transformerSupportDelegate.transformSourceToResult(responseSource, response.getPayloadResult());
            this.toSoapHeaders(response, replyMessage);
        }
    }

    private static class TransformerSupportDelegate
    extends TransformerObjectSupport {
        private TransformerSupportDelegate() {
        }

        void transformSourceToResult(Source source, Result result) throws TransformerException {
            this.transform(source, result);
        }
    }
}

