/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.transformer.HeaderEnricher;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Node;

public class XPathHeaderEnricher
extends HeaderEnricher {
    public XPathHeaderEnricher(Map<String, XPathExpressionEvaluatingHeaderValueMessageProcessor> expressionMap) {
        super(expressionMap);
    }

    static class XPathExpressionEvaluatingHeaderValueMessageProcessor
    implements HeaderValueMessageProcessor<Object> {
        private final XPathExpression expression;
        private volatile XmlPayloadConverter converter = new DefaultXmlPayloadConverter();
        private volatile XPathEvaluationType evaluationType = XPathEvaluationType.STRING_RESULT;
        private volatile Boolean overwrite = null;

        public XPathExpressionEvaluatingHeaderValueMessageProcessor(String expression) {
            Assert.hasText((String)expression, (String)"expression must have text");
            this.expression = XPathExpressionFactory.createXPathExpression((String)expression);
        }

        public XPathExpressionEvaluatingHeaderValueMessageProcessor(XPathExpression expression) {
            Assert.notNull((Object)expression, (String)"expression must not be null");
            this.expression = expression;
        }

        public void setEvaluationType(XPathEvaluationType evaluationType) {
            this.evaluationType = evaluationType;
        }

        public void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public Boolean isOverwrite() {
            return this.overwrite;
        }

        public Object processMessage(Message<?> message) {
            Node node = this.converter.convertToNode(message.getPayload());
            Object result = this.evaluationType.evaluateXPath(this.expression, node);
            if (result instanceof String && ((String)result).length() == 0) {
                result = null;
            }
            return result;
        }
    }
}

