/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.source;

import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.integration.MessagingException;
import org.springframework.integration.xml.source.SourceFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DomSourceFactory
implements SourceFactory {
    private final DocumentBuilderFactory documentBuilderFactory;

    public DomSourceFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.documentBuilderFactory = factory;
    }

    public DomSourceFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    @Override
    public Source createSource(Object payload) {
        DOMSource source = null;
        if (payload instanceof Document) {
            source = this.createDomSourceForDocument((Document)payload);
        } else if (payload instanceof String) {
            source = this.createDomSourceForString((String)payload);
        } else if (payload instanceof File) {
            source = this.createDomSourceForFile((File)payload);
        }
        if (source == null) {
            throw new MessagingException("failed to create Source for payload type [" + payload.getClass().getName() + "]");
        }
        return source;
    }

    private DOMSource createDomSourceForDocument(Document document) {
        return new DOMSource(document.getDocumentElement());
    }

    private DOMSource createDomSourceForString(String s) {
        try {
            Document document = this.getNewDocumentBuilder().parse(new InputSource(new StringReader(s)));
            return new DOMSource(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new MessagingException("failed to create DOMSource for String payload", (Throwable)e);
        }
    }

    private DOMSource createDomSourceForFile(File file) {
        try {
            Document document = this.getNewDocumentBuilder().parse(file);
            return new DOMSource(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new MessagingException("failed to create DOMSource for File payload", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
    }
}

