/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.xml.result.DomResultFactory;
import org.springframework.integration.xml.result.ResultFactory;
import org.springframework.integration.xml.result.StringResultFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractXmlTransformer
extends AbstractTransformer {
    public static final String DOM_RESULT = "DOMResult";
    public static final String STRING_RESULT = "StringResult";
    private volatile String resultType;
    private volatile String resultFactoryName;
    private volatile ResultFactory resultFactory = new DomResultFactory();

    public void setResultFactoryName(String resultFactoryName) {
        this.resultFactoryName = resultFactoryName;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public void setResultFactory(ResultFactory resultFactory) {
        Assert.notNull((Object)resultFactory, (String)"ResultFactory must not be null");
        this.resultFactory = resultFactory;
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getResultFactoryName() {
        return this.resultFactoryName;
    }

    public ResultFactory getResultFactory() {
        return this.resultFactory;
    }

    protected void onInit() {
        super.onInit();
        ResultFactory generatedResultFactory = this.configureResultFactory(this.resultType, this.resultFactoryName, this.getBeanFactory());
        if (generatedResultFactory != null) {
            this.resultFactory = generatedResultFactory;
        }
    }

    private ResultFactory configureResultFactory(String resultType, String resultFactoryName, BeanFactory beanFactory) {
        boolean bothHaveText = StringUtils.hasText((String)resultFactoryName) && StringUtils.hasText((String)resultType);
        ResultFactory configuredResultFactory = null;
        Assert.state((!bothHaveText ? 1 : 0) != 0, (String)"Only one of 'result-factory' or 'result-type' should be specified.");
        if (StringUtils.hasText((String)resultType)) {
            Assert.state((resultType.equals(DOM_RESULT) || resultType.equals(STRING_RESULT) ? 1 : 0) != 0, (String)"Result type must be either 'DOMResult' or 'StringResult'");
        }
        if (StringUtils.hasText((String)resultFactoryName)) {
            configuredResultFactory = (ResultFactory)beanFactory.getBean(resultFactoryName);
        } else if (STRING_RESULT.equals(resultType)) {
            configuredResultFactory = new StringResultFactory();
        } else if (DOM_RESULT.equals(resultType)) {
            configuredResultFactory = new DomResultFactory();
        }
        return configuredResultFactory;
    }
}

